/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.actions;

import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.node.BaseNode;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.OpenQueryEditorAction;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class CriteriaEditorAction
extends OpenQueryEditorAction {
    public static final String CRITERIAEDITOR_ACTIONID = "actionid.criteriaeditor";

    public CriteriaEditorAction() {
        super(HibernateConsoleMessages.CriteriaEditorAction_hibernate_criteria_editor);
        this.setImageDescriptor(EclipseImages.getImageDescriptor("images/criteria_editor.gif"));
        this.setToolTipText(HibernateConsoleMessages.CriteriaEditorAction_open_hibernate_criteria_editor);
        this.setEnabled(true);
        this.setId(CRITERIAEDITOR_ACTIONID);
    }

    @Override
    protected void openQueryEditor(ConsoleConfiguration config, String query) {
        HibernateConsolePlugin.getDefault().openCriteriaEditor(config == null ? null : config.getName(), query);
    }

    @Override
    protected String generateQuery(TreePath path) {
        String enCriteria = "";
        String propCriteria = "";
        String enName = "";
        Object node = path.getLastSegment();
        if (node instanceof PersistentClass) {
            enName = ((PersistentClass)node).getEntityName();
            enName = enName.substring(enName.lastIndexOf(46) + 1);
        } else if (node instanceof Property) {
            Property prop = (Property)node;
            String prName = prop.getName();
            PersistentClass pClass = prop.getPersistentClass();
            if (pClass != null) {
                enName = pClass.getEntityName();
                enName = enName.substring(enName.lastIndexOf(46) + 1);
                propCriteria = prop.getValue().isSimpleValue() ? NLS.bind((String)"\n.setProjection(Property.forName(\"{0}\").as(\"{0}\"))", (Object)prName) : NLS.bind((String)"\n.createCriteria(\"{0}\", \"{1}\")", (Object)prName, (Object)Character.valueOf(prName.charAt(0)));
            } else {
                int i = path.getSegmentCount() - 1;
                while (i > 0) {
                    if (path.getSegment(i) instanceof PersistentClass) {
                        enName = ((PersistentClass)path.getSegment(i)).getEntityName();
                        enName = enName.substring(enName.lastIndexOf(46) + 1);
                    } else if (path.getSegment(i) instanceof Property) {
                        prName = ((Property)path.getSegment(i)).getName();
                        propCriteria = prop.getValue().isSimpleValue() ? String.valueOf(propCriteria) + NLS.bind((String)"\n.setProjection(Property.forName(\"{0}\").as(\"{0}\"))", (Object)prName) : String.valueOf(propCriteria) + NLS.bind((String)"\n.createCriteria(\"{0}\", \"{1}\")", (Object)prName, (Object)Character.valueOf(prName.charAt(0)));
                    }
                    --i;
                }
            }
        } else if (node instanceof BaseNode) {
            return ((BaseNode)node).getCriteria();
        }
        if ("".equals(enName)) {
            return "";
        }
        enCriteria = NLS.bind((String)".createCriteria({0})", (Object)(String.valueOf(enName) + ".class"));
        return "session" + enCriteria + propCriteria;
    }
}

