/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views.navigator;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.hibernate.eclipse.console.views.navigator.ClearPlaceHolderJob;
import org.hibernate.eclipse.console.views.navigator.PendingNode;
import org.hibernate.eclipse.console.views.navigator.PendingUIJob;

public class PendingJob
extends Job {
    private ITreeContentProvider contentProvider;
    private PendingNode placeHolder;
    private AbstractTreeViewer viewer;
    private Object parent;

    public PendingJob(AbstractTreeViewer viewer, PendingNode placeHolder, Object parent, ITreeContentProvider contentProvider) {
        super(placeHolder.getText());
        this.viewer = viewer;
        this.placeHolder = placeHolder;
        this.parent = parent;
        this.contentProvider = contentProvider;
        this.setRule(NonConflictingRule.INSTANCE);
    }

    protected IStatus run(IProgressMonitor monitor) {
        Object[] rootObjects;
        PendingUIJob updateUIJob = new PendingUIJob((StructuredViewer)this.viewer, this.placeHolder);
        updateUIJob.schedule();
        ArrayList<Object> children = new ArrayList<Object>();
        Object[] objectArray = rootObjects = this.contentProvider != null ? this.contentProvider.getChildren(this.parent) : null;
        if (rootObjects != null) {
            int x = 0;
            while (x < rootObjects.length) {
                children.add(rootObjects[x]);
                ++x;
            }
        }
        updateUIJob.setComplete(true);
        new ClearPlaceHolderJob(this.viewer, this.placeHolder, this.parent, children.toArray()).schedule();
        return Status.OK_STATUS;
    }

    public static class NonConflictingRule
    implements ISchedulingRule {
        public static final NonConflictingRule INSTANCE = new NonConflictingRule();

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

