/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph.parts;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.hibernate.eclipse.graph.model.AssociationViewAdapter;
import org.hibernate.eclipse.graph.model.GraphNode;

public abstract class GraphNodeEditPart
extends AbstractGraphicalEditPart
implements Observer,
NodeEditPart {
    protected abstract IFigure createFigure();

    protected abstract void createEditPolicies();

    @Override
    public void update(Observable o, Object arg) {
        if (arg == "ASSOCIATIONS") {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        } else {
            this.refreshVisuals();
        }
    }

    protected List<AssociationViewAdapter> getModelSourceConnections() {
        return this.getGraphNode().getSourceAssociations();
    }

    public GraphNode getGraphNode() {
        return (GraphNode)this.getModel();
    }

    protected List<AssociationViewAdapter> getModelTargetConnections() {
        return this.getGraphNode().getTargetAssociations();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public void activate() {
        super.activate();
        Observable o = (Observable)this.getModel();
        o.addObserver(this);
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    public void deactivate() {
        super.deactivate();
        Observable o = (Observable)this.getModel();
        o.deleteObserver(this);
    }

    protected void refreshVisuals() {
        GraphicalEditPart parent = (GraphicalEditPart)this.getParent();
        Rectangle bounds = this.getGraphNode().getBounds().getCopy();
        parent.setLayoutConstraint((EditPart)this, this.getFigure(), (Object)bounds);
    }
}

