/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Settings;
import org.hibernate.console.ConfigurationFactory;
import org.hibernate.console.ConsoleConfigClassLoader;
import org.hibernate.console.ConsoleConfigurationListener;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.QueryPage;
import org.hibernate.console.execution.DefaultExecutionContext;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.execution.ExecutionContextHolder;
import org.hibernate.console.ext.HibernateExtension;
import org.hibernate.console.ext.HibernateExtensionDefinition;
import org.hibernate.console.ext.HibernateExtensionManager;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.console.preferences.PreferencesClassPathUtils;
import org.hibernate.eclipse.libs.FakeDelegatingDriver;
import org.hibernate.tool.hbm2x.StringUtils;

public class ConsoleConfiguration
implements ExecutionContextHolder {
    private ExecutionContext executionContext;
    private ConsoleConfigClassLoader classLoader = null;
    private Map<String, FakeDelegatingDriver> fakeDrivers = new HashMap<String, FakeDelegatingDriver>();
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private String hibernateVersion = "==<None>==";
    private HibernateExtension extension;
    public ConsoleConfigurationPreferences prefs = null;
    int execcount;
    ArrayList<ConsoleConfigurationListener> consoleCfgListeners = new ArrayList();

    private void loadHibernateExtension() {
        String version = this.hibernateVersion == null ? "3.5" : this.hibernateVersion;
        HibernateExtensionDefinition def = HibernateExtensionManager.findHibernateExtensionDefinition(version);
        if (def == null) {
            throw new IllegalArgumentException("Can't find definition for hibernate version " + version);
        }
        HibernateExtension hibernateExtension = def.createHibernateExtensionInstance();
        hibernateExtension.setConsoleConfigurationPreferences(this.prefs);
        this.extension = hibernateExtension;
    }

    private void updateHibernateVersion(String hibernateVersion) {
        if (!StringUtils.equals((String)this.hibernateVersion, (String)hibernateVersion)) {
            this.hibernateVersion = hibernateVersion;
            this.loadHibernateExtension();
        }
    }

    public HibernateExtension getHibernateExtension() {
        this.updateHibernateVersion(this.prefs.getHibernateVersion());
        return this.extension;
    }

    public ConsoleConfiguration(ConsoleConfigurationPreferences config) {
        this.prefs = config;
    }

    public String getName() {
        return this.prefs.getName();
    }

    public synchronized Object execute(ExecutionContext.Command c) {
        if (this.executionContext != null) {
            return this.executionContext.execute(c);
        }
        String msg = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_null_execution_context, (Object)this.getName());
        throw new HibernateConsoleRuntimeException(msg);
    }

    public synchronized boolean reset() {
        boolean resetted = false;
        if (this.getHibernateExtension() != null) {
            this.getHibernateExtension().reset();
            this.getHibernateExtension().closeSessionFactory();
        }
        if (this.configuration != null) {
            this.configuration = null;
            resetted = true;
        }
        if (resetted = resetted | this.closeSessionFactory() | this.cleanUpClassLoader()) {
            this.fireConfigurationReset();
        }
        this.executionContext = null;
        return resetted;
    }

    protected boolean cleanUpClassLoader() {
        boolean resetted = false;
        if (this.executionContext != null) {
            this.executionContext.execute(new ExecutionContext.Command(){

                @Override
                public Object execute() {
                    Iterator it = ConsoleConfiguration.this.fakeDrivers.values().iterator();
                    while (it.hasNext()) {
                        try {
                            DriverManager.deregisterDriver((Driver)it.next());
                        }
                        catch (SQLException sQLException) {}
                    }
                    return null;
                }
            });
        }
        if (this.fakeDrivers.size() > 0) {
            this.fakeDrivers.clear();
            resetted = true;
        }
        ClassLoader classLoaderTmp = this.classLoader;
        while (classLoaderTmp != null) {
            if (classLoaderTmp instanceof ConsoleConfigClassLoader) {
                classLoaderTmp.close();
                resetted = true;
            }
            classLoaderTmp = classLoaderTmp.getParent();
        }
        if (this.classLoader != null) {
            this.classLoader = null;
            resetted = true;
        }
        return resetted;
    }

    protected void reinitClassLoader() {
        URL[] customClassPathURLs = PreferencesClassPathUtils.getCustomClassPathURLs(this.prefs);
        this.cleanUpClassLoader();
        this.classLoader = this.createClassLoader(customClassPathURLs);
    }

    public void build() {
        this.reset();
        this.configuration = this.buildWith(null, true);
        this.getHibernateExtension().build();
        this.fireConfigurationBuilt();
    }

    protected ConsoleConfigClassLoader createClassLoader(final URL[] customClassPathURLs) {
        ConsoleConfigClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ConsoleConfigClassLoader>(){

            @Override
            public ConsoleConfigClassLoader run() {
                return new ConsoleConfigClassLoader(customClassPathURLs, ConsoleConfiguration.this.getParentClassLoader()){

                    @Override
                    protected Class<?> findClass(String name) throws ClassNotFoundException {
                        return super.findClass(name);
                    }

                    @Override
                    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        return super.loadClass(name, resolve);
                    }

                    @Override
                    public Class<?> loadClass(String name) throws ClassNotFoundException {
                        return super.loadClass(name);
                    }

                    @Override
                    public URL getResource(String name) {
                        return super.getResource(name);
                    }
                };
            }
        });
        return classLoader;
    }

    public Configuration buildWith(final Configuration cfg, final boolean includeMappings) {
        this.reinitClassLoader();
        this.executionContext = new DefaultExecutionContext(this.getName(), this.classLoader);
        Configuration result = (Configuration)this.execute(new ExecutionContext.Command(){

            @Override
            public Object execute() {
                ConfigurationFactory csf = new ConfigurationFactory(ConsoleConfiguration.this.prefs, ConsoleConfiguration.this.fakeDrivers);
                return csf.createConfiguration(cfg, includeMappings);
            }
        });
        return result;
    }

    protected ClassLoader getParentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public void buildMappings() {
        this.execute(new ExecutionContext.Command(){

            @Override
            public Object execute() {
                ConsoleConfiguration.this.getConfiguration().buildMappings();
                return null;
            }
        });
        this.getHibernateExtension().buildMappings();
    }

    public void buildSessionFactory() {
        this.execute(new ExecutionContext.Command(){

            @Override
            public Object execute() {
                if (ConsoleConfiguration.this.sessionFactory != null) {
                    throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_factory_not_closed_before_build_new_factory);
                }
                ConsoleConfiguration.this.sessionFactory = ConsoleConfiguration.this.getConfiguration().buildSessionFactory();
                ConsoleConfiguration.this.fireFactoryBuilt();
                return null;
            }
        });
        this.getHibernateExtension().buildSessionFactory();
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public QueryPage executeHQLQuery(String hql) {
        return this.executeHQLQuery(hql, new QueryInputModel());
    }

    public QueryPage executeHQLQuery(String hql, QueryInputModel queryParameters) {
        QueryPage qp = this.getHibernateExtension().executeHQLQuery(hql, queryParameters);
        qp.setId(++this.execcount);
        this.fireQueryPageCreated(qp);
        return qp;
    }

    public QueryPage executeBSHQuery(String queryString, QueryInputModel model) {
        QueryPage qp = this.getHibernateExtension().executeCriteriaQuery(queryString, model);
        qp.setId(++this.execcount);
        this.fireQueryPageCreated(qp);
        return qp;
    }

    private ArrayList<ConsoleConfigurationListener> cloneConsoleCfgListeners() {
        return (ArrayList)this.consoleCfgListeners.clone();
    }

    private void fireConfigurationBuilt() {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.configurationBuilt(this);
        }
    }

    private void fireConfigurationReset() {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.configurationReset(this);
        }
    }

    private void fireQueryPageCreated(QueryPage qp) {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.queryPageCreated(qp);
        }
    }

    private void fireFactoryBuilt() {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.sessionFactoryBuilt(this, this.sessionFactory);
        }
    }

    private void fireFactoryClosing(SessionFactory sessionFactory2) {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.sessionFactoryClosing(this, sessionFactory2);
        }
    }

    public void addConsoleConfigurationListener(ConsoleConfigurationListener v) {
        this.consoleCfgListeners.add(v);
    }

    public void removeConsoleConfigurationListener(ConsoleConfigurationListener sfListener) {
        this.consoleCfgListeners.remove(sfListener);
    }

    public ConsoleConfigurationListener[] getConsoleConfigurationListeners() {
        return this.consoleCfgListeners.toArray(new ConsoleConfigurationListener[this.consoleCfgListeners.size()]);
    }

    public boolean isSessionFactoryCreated() {
        return this.sessionFactory != null;
    }

    public ConsoleConfigurationPreferences getPreferences() {
        return this.prefs;
    }

    public File getConfigXMLFile() {
        URI uri;
        URL url;
        File configXMLFile = null;
        if (this.prefs != null) {
            configXMLFile = this.prefs.getConfigXMLFile();
        }
        if (configXMLFile == null) {
            url = null;
            if (this.classLoader != null) {
                url = this.classLoader.findResource("hibernate.cfg.xml");
            }
            if (url != null) {
                uri = null;
                try {
                    uri = url.toURI();
                    configXMLFile = new File(uri);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        if (configXMLFile == null && (url = Environment.class.getClassLoader().getResource("hibernate.cfg.xml")) != null) {
            uri = null;
            try {
                uri = url.toURI();
                configXMLFile = new File(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return configXMLFile;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.getName();
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public boolean closeSessionFactory() {
        boolean resetted = false;
        if (this.sessionFactory != null) {
            this.fireFactoryClosing(this.sessionFactory);
            this.sessionFactory.close();
            this.sessionFactory = null;
            resetted = true;
        }
        if (this.getHibernateExtension() != null) {
            this.getHibernateExtension().closeSessionFactory();
        }
        return resetted;
    }

    public Settings getSettings(final Configuration cfg) {
        return (Settings)this.execute(new ExecutionContext.Command(){

            @Override
            public Object execute() {
                return cfg.buildSettings();
            }
        });
    }
}

