/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.NodeFactory;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.workbench.BasicWorkbenchAdapter;
import org.hibernate.eclipse.console.workbench.LazySessionFactory;

public class LazySessionFactoryAdapter
extends BasicWorkbenchAdapter {
    public Object[] getChildren(Object o) {
        LazySessionFactory lazySessionFactory = this.getLazySessionFactory(o);
        String label = HibernateConsoleMessages.LazySessionFactoryAdapter_session_factory;
        if (lazySessionFactory.getCfgNode() == null) {
            if (lazySessionFactory.getConsoleConfiguration().getSessionFactory() == null) {
                try {
                    lazySessionFactory.getConsoleConfiguration().buildSessionFactory();
                }
                catch (Throwable t) {
                    label = NLS.bind((String)HibernateConsoleMessages.LazySessionFactoryAdapter_sessionfactory_error, (Object)t.getMessage());
                    HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.LazySessionFactoryAdapter_problems_while_creating_sessionfactory, t);
                }
            }
            if (lazySessionFactory.getConsoleConfiguration().isSessionFactoryCreated()) {
                NodeFactory fac = new NodeFactory(lazySessionFactory.getConsoleConfiguration());
                lazySessionFactory.setCfgNode(fac.createConfigurationEntitiesNode(label));
            }
        }
        if (lazySessionFactory.getCfgNode() != null) {
            return LazySessionFactoryAdapter.toArray(lazySessionFactory.getCfgNode().children(), BaseNode.class);
        }
        return new Object[]{label};
    }

    private LazySessionFactory getLazySessionFactory(Object o) {
        return (LazySessionFactory)o;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return EclipseImages.getImageDescriptor("TYPES");
    }

    public String getLabel(Object o) {
        return HibernateConsoleMessages.LazySessionFactoryAdapter_session_factory;
    }

    public Object getParent(Object o) {
        return this.getLazySessionFactory(o).getConsoleConfiguration();
    }
}

