/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.hibernate.eclipse.console.workbench.Messages;

public class ProjectCompilerVersionChecker {
    public static boolean validateProjectComplianceLevel(ConsoleConfiguration ccfg) {
        IJavaProject[] javaProjects = ProjectUtils.findJavaProjects(ccfg);
        if (javaProjects.length > 0) {
            IJavaProject[] iJavaProjectArray = javaProjects;
            int n = javaProjects.length;
            int n2 = 0;
            while (n2 < n) {
                final IJavaProject iJavaProject = iJavaProjectArray[n2];
                if (iJavaProject.exists()) {
                    String projectTarget = iJavaProject.getOption("org.eclipse.jdt.core.compiler.codegen.targetPlatform", true);
                    String eclipseCompilerVersion = System.getProperty("java.specification.version");
                    long projectJdkLevel = CompilerOptions.versionToJdkLevel((Object)projectTarget);
                    long eclipseJdkLevel = CompilerOptions.versionToJdkLevel((Object)eclipseCompilerVersion);
                    if (eclipseJdkLevel < projectJdkLevel) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openWarning(null, (String)Messages.ProjectCompilerVersionChecker_title, (String)NLS.bind((String)Messages.ProjectCompilerVersionChecker_message, (Object)iJavaProject.getElementName()));
                            }
                        });
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }
}

