/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.IOException;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.storage.dfs.DfsPackFile;
import org.eclipse.jgit.storage.dfs.DfsReader;
import org.eclipse.jgit.storage.pack.CachedPack;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackOutputStream;
import org.eclipse.jgit.storage.pack.StoredObjectRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfsCachedPack
extends CachedPack {
    private final DfsPackFile pack;

    DfsCachedPack(DfsPackFile pack) {
        this.pack = pack;
    }

    public DfsPackDescription getPackDescription() {
        return this.pack.getPackDescription();
    }

    @Override
    public Set<ObjectId> getTips() {
        return this.getPackDescription().getTips();
    }

    @Override
    public long getObjectCount() throws IOException {
        return this.getPackDescription().getObjectCount();
    }

    @Override
    public long getDeltaCount() throws IOException {
        return this.getPackDescription().getDeltaCount();
    }

    @Override
    public boolean hasObject(ObjectToPack obj, StoredObjectRepresentation rep) {
        return ((DfsObjectRepresentation)rep).pack == this.pack;
    }

    void copyAsIs(PackOutputStream out, boolean validate, DfsReader ctx) throws IOException {
        this.pack.copyPackAsIs(out, validate, ctx);
    }
}

