/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IDomain;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.IOpenShiftSSHKey;
import com.openshift.client.ISSHPublicKey;
import com.openshift.client.IUser;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftSSHKeyException;
import com.openshift.client.OpenShiftUnknonwSSHKeyTypeException;
import com.openshift.client.SSHKeyType;
import com.openshift.internal.client.APIResource;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.DomainResource;
import com.openshift.internal.client.SSHKeyResource;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.response.KeyResourceDTO;
import com.openshift.internal.client.response.UserResourceDTO;
import com.openshift.internal.client.utils.CollectionUtils;
import java.util.ArrayList;
import java.util.List;

public class UserResource
extends AbstractOpenShiftResource
implements IUser {
    private final APIResource api;
    private final String rhLogin;
    private final String password;
    private List<SSHKeyResource> sshKeys;

    public UserResource(APIResource api, UserResourceDTO dto, String password) {
        super(api.getService(), dto.getLinks(), dto.getCreationLog());
        this.api = api;
        this.rhLogin = dto.getRhLogin();
        this.password = password;
    }

    @Override
    public IOpenShiftConnection getConnection() {
        return this.api;
    }

    @Override
    public String getRhlogin() {
        return this.rhLogin;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getAuthKey() {
        return null;
    }

    @Override
    public String getAuthIV() {
        return null;
    }

    @Override
    public IDomain createDomain(String name) throws OpenShiftException {
        return this.api.createDomain(name);
    }

    @Override
    public List<IDomain> getDomains() throws OpenShiftException {
        return this.api.getDomains();
    }

    @Override
    public IDomain getDefaultDomain() throws OpenShiftException {
        List<IDomain> domains = this.api.getDomains();
        if (domains.size() > 0) {
            return domains.get(0);
        }
        return null;
    }

    @Override
    public IDomain getDomain(String namespace) throws OpenShiftException {
        return this.api.getDomain(namespace);
    }

    @Override
    public boolean hasDomain() throws OpenShiftException {
        return this.api.getDomains().size() > 0;
    }

    @Override
    public void refresh() throws OpenShiftException {
        DomainResource defaultDomain;
        if (this.sshKeys != null) {
            this.sshKeys = null;
            this.loadKeys();
        }
        if ((defaultDomain = (DomainResource)this.getDefaultDomain()) != null) {
            defaultDomain.refresh();
        }
    }

    @Override
    public List<IOpenShiftSSHKey> getSSHKeys() throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        ArrayList<SSHKeyResource> keys = new ArrayList<SSHKeyResource>();
        keys.addAll(this.getCachedOrLoadSSHKeys());
        return CollectionUtils.toUnmodifiableCopy(keys);
    }

    private List<SSHKeyResource> getCachedOrLoadSSHKeys() throws OpenShiftException, OpenShiftUnknonwSSHKeyTypeException {
        if (this.sshKeys == null) {
            this.sshKeys = this.loadKeys();
        }
        return this.sshKeys;
    }

    private List<SSHKeyResource> loadKeys() throws OpenShiftException, OpenShiftUnknonwSSHKeyTypeException {
        ArrayList<SSHKeyResource> keys = new ArrayList<SSHKeyResource>();
        List<KeyResourceDTO> keyDTOs = new GetSShKeysRequest().execute();
        for (KeyResourceDTO keyDTO : keyDTOs) {
            keys.add(new SSHKeyResource(keyDTO, this));
        }
        return keys;
    }

    @Override
    public IOpenShiftSSHKey getSSHKeyByName(String name) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        SSHKeyResource matchingKey = null;
        if (name == null) {
            return null;
        }
        for (SSHKeyResource key : this.getCachedOrLoadSSHKeys()) {
            if (!name.equals(key.getName())) continue;
            matchingKey = key;
            break;
        }
        return matchingKey;
    }

    @Override
    public IOpenShiftSSHKey getSSHKeyByPublicKey(String publicKey) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        SSHKeyResource matchingKey = null;
        if (publicKey == null) {
            return null;
        }
        for (SSHKeyResource key : this.getCachedOrLoadSSHKeys()) {
            if (!publicKey.equals(key.getPublicKey())) continue;
            matchingKey = key;
            break;
        }
        return matchingKey;
    }

    @Override
    public boolean hasSSHKeyName(String name) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        return this.getSSHKeyByName(name) != null;
    }

    @Override
    public boolean hasSSHPublicKey(String publicKey) throws OpenShiftUnknonwSSHKeyTypeException, OpenShiftException {
        return this.getSSHKeyByPublicKey(publicKey) != null;
    }

    @Override
    public IOpenShiftSSHKey putSSHKey(String name, ISSHPublicKey key) throws OpenShiftException {
        if (this.hasSSHKeyName(name)) {
            throw new OpenShiftSSHKeyException("Could not add new key {0} with the name {1}. There already is a key for this name, key names must be unique.", key.getPublicKey(), name);
        }
        if (this.hasSSHPublicKey(name)) {
            throw new OpenShiftSSHKeyException("Could not add new key {0} with the name {1}. The key is already stored with a different name. Public key have to be unique.", key.getPublicKey(), name);
        }
        KeyResourceDTO keyDTO = new AddSShKeyRequest().execute(key.getKeyType(), name, key.getPublicKey());
        return this.put(keyDTO);
    }

    private SSHKeyResource put(KeyResourceDTO keyDTO) throws OpenShiftUnknonwSSHKeyTypeException {
        SSHKeyResource sshKey = new SSHKeyResource(keyDTO, this);
        this.sshKeys.add(sshKey);
        return sshKey;
    }

    protected void removeSSHKey(SSHKeyResource key) {
        this.sshKeys.remove(key);
    }

    private class AddSShKeyRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public AddSShKeyRequest() throws OpenShiftException {
            super("ADD_KEY");
        }

        public KeyResourceDTO execute(SSHKeyType type, String name, String content) throws OpenShiftException {
            return (KeyResourceDTO)super.execute(new ServiceParameter("type", type.getTypeId()), new ServiceParameter("name", name), new ServiceParameter("content", content));
        }
    }

    private class GetSShKeysRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        public GetSShKeysRequest() throws OpenShiftException {
            super("LIST_KEYS");
        }

        public List<KeyResourceDTO> execute() throws OpenShiftException {
            return (List)super.execute(new ServiceParameter[0]);
        }
    }
}

