/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.XActionImpl;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.OWEProcess;
import org.jboss.tools.common.meta.action.impl.handlers.OpenWithHelper;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class OpenWithExternalHandler
extends AbstractHandler {
    @Override
    public boolean isEnabled(XModelObject object) {
        boolean b;
        if (object == null || object.getFileType() != 1) {
            return false;
        }
        String s = this.getEditorName(object);
        boolean bl = b = s != null;
        if (!b) {
            s = "?";
        }
        ((XActionImpl)this.action).setDisplayName(s);
        return b;
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        String displayName = WizardKeys.getMenuItemDisplayName(this.action, object == null ? null : object.getModelEntity());
        if (!OpenWithExternalHandler.checkSave(displayName, object)) {
            return;
        }
        String f = this.getFileName(object);
        String ext = OpenWithHelper.getLogicalExtension(object, this.action);
        XModelObject editor = OpenWithHelper.getEditorObject(object.getModel(), ext);
        if (editor == null) {
            throw new RuntimeException("External editor for file extension '" + ext + "' is not set.");
        }
        OpenWithExternalHandler.start(displayName, f, editor);
    }

    static boolean checkSave(String actionname, XModelObject object) throws XModelException {
        String mes;
        if (!(object.isModified() && object.isActive() && object.getParent() instanceof FolderImpl)) {
            return true;
        }
        ServiceDialog d = object.getModel().getService();
        int i = d.showDialog(actionname, mes = MessageFormat.format("{0} is modified.\nDo you want to save it on disk before launching the external program?", DefaultCreateHandler.title(object, true)), new String[]{ModelMessages.Yes, ModelMessages.No, ModelMessages.Cancel}, null, 0);
        if (i == 0) {
            ((FolderImpl)object.getParent()).saveChild(object);
            return !object.isModified();
        }
        return i == 1;
    }

    protected String getFileName(XModelObject object) {
        return OpenWithHelper.getFileName(object);
    }

    private String getEditorName(XModelObject object) {
        String ext = OpenWithHelper.getLogicalExtension(object, this.action);
        XModelObject o = object.getModel().getByPath(OpenWithHelper.EDITORS);
        String[] es = XModelObjectUtil.asStringArray(o.getAttributeValue("extensions"));
        int i = 0;
        while (i < es.length) {
            if (es[i].toLowerCase().startsWith(String.valueOf(ext.toLowerCase()) + ":")) {
                return es[i].substring(ext.length() + 1);
            }
            ++i;
        }
        return null;
    }

    public static void start(String actionname, String filename, XModelObject editor) throws XModelException {
        String fn;
        int i = filename.indexOf(35);
        String string = fn = i < 0 ? filename : filename.substring(0, i);
        if (!new File(fn).isFile()) {
            throw new IllegalArgumentException("Cannot find file " + fn + ".");
        }
        if (OpenWithHelper.validatePath(actionname, editor)) {
            new OWEProcess(editor, filename).start();
        }
    }
}

