/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validation;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.ValidationErrorManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.common.validation.internal.ProjectValidationContext;
import org.jboss.tools.common.validation.internal.SimpleValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;
import org.jboss.tools.common.web.WebUtils;
import org.jboss.tools.jst.web.WebModelPlugin;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.validation.Check;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.validation.ActionForwardCheck;
import org.jboss.tools.struts.validation.ActionNameCheck;
import org.jboss.tools.struts.validation.ActionRefsCheck;
import org.jboss.tools.struts.validation.ActionTypeCheck;
import org.jboss.tools.struts.validation.CheckInitParam;
import org.jboss.tools.struts.validation.GlobalExceptionCheck;
import org.jboss.tools.struts.validation.GlobalForwardCheck;
import org.jboss.tools.struts.validation.ResourceCheck;
import org.jboss.tools.struts.validation.StrutsConfigCheck;
import org.jboss.tools.struts.validation.StrutsConfigControllerCheck;
import org.jboss.tools.struts.validation.StrutsPreferences;
import org.jboss.tools.struts.validation.StrutsValidatorMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrutsCoreValidator
extends ValidationErrorManager
implements org.jboss.tools.common.validation.IValidator,
StrutsConstants {
    public static final String ID = "org.jboss.tools.struts.validation.StrutsCoreValidator";
    public static final String PROBLEM_TYPE = "org.jboss.tools.struts.strutsproblem";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.struts.ui.StrutsValidatorPreferencePage";
    public static String SHORT_ID = "verification";
    static String XML_EXT = ".xml";
    String projectName;
    Map<IProject, IProjectValidationContext> contexts = new HashMap<IProject, IProjectValidationContext>();
    Map<String, Set<Check>> checks = new HashMap<String, Set<Check>>();

    public StrutsCoreValidator() {
        this.createChecks();
    }

    protected String getPreference(IProject project, String preferenceKey) {
        return StrutsPreferences.getInstance().getProjectPreference(project, preferenceKey);
    }

    public int getMaxNumberOfMarkersPerFile(IProject project) {
        return StrutsPreferences.getMaxNumberOfProblemMarkersPerFile(project);
    }

    private void addCheck(Check check, String ... entities) {
        String[] stringArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity = stringArray[n2];
            Set<Check> cs = this.checks.get(entity);
            if (cs == null) {
                cs = new HashSet<Check>();
                this.checks.put(entity, cs);
            }
            cs.add(check);
            ++n2;
        }
    }

    void createChecks() {
        this.addCheck(new ActionForwardCheck(this, StrutsPreferences.INVALID_ACTION_FORWARD), "StrutsForward10", "StrutsForward11", "StrutsForward12");
        this.addCheck(new ActionNameCheck(this, StrutsPreferences.INVALID_ACTION_NAME), "StrutsAction10", "StrutsAction11", "StrutsAction12");
        this.addCheck(new ActionRefsCheck(this, StrutsPreferences.INVALID_ACTION_REFERENCE_ATTRIBUTE), "StrutsAction10", "StrutsAction11", "StrutsAction12");
        this.addCheck(new ActionTypeCheck(this, StrutsPreferences.INVALID_ACTION_TYPE), "StrutsAction10", "StrutsAction11", "StrutsAction12");
        this.addCheck(new GlobalExceptionCheck(this, StrutsPreferences.INVALID_GLOBAL_EXCEPTION), "StrutsException11");
        this.addCheck(new GlobalForwardCheck(this, StrutsPreferences.INVALID_GLOBAL_FORWARD), "StrutsForward10", "StrutsForward11", "StrutsForward12");
        this.addCheck(new StrutsConfigControllerCheck(this, StrutsPreferences.INVALID_CONTROLLER), "StrutsController11", "StrutsController12");
        this.addCheck(new ResourceCheck(this, StrutsPreferences.INVALID_MESSAGE_RESOURCES), "StrutsMessageResources11");
        this.addCheck(new StrutsConfigCheck(this, StrutsPreferences.INVALID_INIT_PARAM), "StrutsConfig10", "StrutsConfig11", "StrutsConfig12");
    }

    public String getMarkerType() {
        return PROBLEM_TYPE;
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return null;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        IProjectValidationContext rootContext = this.contexts.get(project);
        if (rootContext == null) {
            rootContext = new ProjectValidationContext();
            this.contexts.put(project, rootContext);
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        projects.add(project);
        ValidatingProjectSet projectSet = new ValidatingProjectSet(project, projects, rootContext);
        return new SimpleValidatingProjectTree((IValidatingProjectSet)projectSet);
    }

    public boolean shouldValidate(IProject project) {
        if (!project.isAccessible()) {
            return false;
        }
        try {
            return project.hasNature("org.jboss.tools.struts.strutsnature");
        }
        catch (CoreException e) {
            WebModelPlugin.getDefault().logError((Throwable)e);
            return false;
        }
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.projectName = project.getName();
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        for (IFile file : changedFiles) {
            if (!file.getName().endsWith(XML_EXT)) continue;
            XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)file);
            if (o != null && o.getModelEntity().getName().startsWith("StrutsConfig")) {
                this.validateStrutsConfigFile(o, file);
                continue;
            }
            if (o == null || !o.getModelEntity().getName().startsWith("FileWebApp")) continue;
            this.validateWebXMLFile(o);
        }
        return this.OK_STATUS;
    }

    private void validateStrutsConfigFile(XModelObject object, IFile file) {
        this.validateObject(object);
    }

    private void validateWebXMLFile(XModelObject object) {
        XModelObject[] ss;
        XModelObject[] xModelObjectArray = ss = WebAppHelper.getServlets((XModelObject)object);
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject servlet = xModelObjectArray[n2];
            XModelObject[] xModelObjectArray2 = servlet.getChildren();
            int n3 = xModelObjectArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                XModelObject p = xModelObjectArray2[n4];
                new CheckInitParam(this, StrutsPreferences.INVALID_INIT_PARAM).check(p);
                ++n4;
            }
            ++n2;
        }
    }

    private void validateObject(XModelObject object) {
        XModelObject[] cs;
        String entity = object.getModelEntity().getName();
        Set<Check> ch = this.checks.get(entity);
        if (ch != null) {
            for (Check c : ch) {
                c.check(object);
            }
        }
        XModelObject[] xModelObjectArray = cs = object.getChildren();
        int n = cs.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject c = xModelObjectArray[n2];
            this.validateObject(c);
            ++n2;
        }
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        this.displaySubtask(StrutsValidatorMessages.VALIDATING_PROJECT, new String[]{this.projectName});
        IPath webContentPath = WebUtils.getFirstWebContentPath((IProject)project);
        IFolder webInf = null;
        try {
            webInf = project.getFolder(webContentPath.removeFirstSegments(1).append("WEB-INF"));
            if (webInf.isAccessible()) {
                IResource[] rs;
                IResource[] iResourceArray = rs = webInf.members();
                int n = rs.length;
                int n2 = 0;
                while (n2 < n) {
                    XModelObject o;
                    IFile file;
                    String name;
                    IResource r = iResourceArray[n2];
                    if (r instanceof IFile && (name = (file = (IFile)r).getName()).endsWith(XML_EXT) && (o = EclipseResourceUtil.createObjectForResource((IResource)file)) != null && o.getModelEntity().getName().startsWith("StrutsConfig")) {
                        this.validateStrutsConfigFile(o, file);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            return new Status(4, "org.jboss.tools.struts", MessageFormat.format("Validation error for project {0}", project.getLocation().toString()), (Throwable)e);
        }
        return this.OK_STATUS;
    }

    public boolean isEnabled(IProject project) {
        return StrutsPreferences.isValidationEnabled(project);
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }
}

