/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.utils;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.internal.ui.stringsubstitution.StringVariableLabelProvider;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.PackageSelectionDialog;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.ProjectUtils;

public class DialogSelectionHelper
extends org.hibernate.eclipse.console.utils.xpl.DialogSelectionHelper {
    public static IJavaProject chooseJavaProject(Shell shell, IJavaProject initialSelection, String title, String description) {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            HibernateConsolePlugin.getDefault().log(e.getStatus());
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.setElements(projects);
        IJavaProject javaProject = initialSelection;
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return initialSelection;
    }

    public static String choosePersistenceUnit(Shell shell, String initialSelection, String title, String description, IJavaProject javaProject) {
        Object[] availablePersistenceUnit = ProjectUtils.availablePersistenceUnits(javaProject);
        StringVariableLabelProvider labelProvider = new StringVariableLabelProvider();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)labelProvider);
        dialog.setTitle(title);
        dialog.setMessage(description);
        dialog.setElements(availablePersistenceUnit);
        String persistenceUnit = initialSelection;
        if (persistenceUnit != null) {
            dialog.setInitialSelections(new Object[]{persistenceUnit});
        }
        if (dialog.open() == 0) {
            return (String)dialog.getFirstResult();
        }
        return initialSelection;
    }

    public static String chooseImplementation(String supertype, String initialSelection, String title, Shell shell) {
        SelectionDialog dialog = null;
        try {
            IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)scope, (int)2, (boolean)false, (String)supertype);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        dialog.setTitle(title);
        dialog.setMessage(title);
        if (dialog.open() == 1) {
            return null;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            return type.getFullyQualifiedName('.');
        }
        return null;
    }

    public static IPackageFragment choosePackage(Shell shell, IJavaElement[] javaProjects, final IFilter filter, String title, String message) {
        BusyIndicatorRunnableContext context = new BusyIndicatorRunnableContext();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProjects, (int)9);
        PackageSelectionDialog packageSelectionDialog = new PackageSelectionDialog(shell, (IRunnableContext)context, 12, scope){

            protected FilteredList createFilteredList(Composite parent) {
                FilteredList list = super.createFilteredList(parent);
                if (filter != null) {
                    list.setFilterMatcher(new FilteredList.FilterMatcher(){

                        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                        }

                        public boolean match(Object element) {
                            return filter.select(element);
                        }
                    });
                }
                return list;
            }
        };
        packageSelectionDialog.setTitle(title);
        packageSelectionDialog.setMessage(message);
        if (packageSelectionDialog.open() == 0) {
            return (IPackageFragment)packageSelectionDialog.getResult()[0];
        }
        return null;
    }
}

