/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.eclipse.console.wizards.Messages;
import org.hibernate.eclipse.launch.ConnectionProfileCtrl;

public class SelectConnectionProfileDialog
extends Dialog {
    private ConnectionProfileCtrl connectionProfileCtrl;
    private String selectedCP = null;

    protected SelectConnectionProfileDialog(Shell shell) {
        super(shell);
    }

    public void setDefaultValue(String str) {
        this.selectedCP = str;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.SelectConnectionProfile);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.getButton(0).setEnabled(this.selectedCP != null);
        return c;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        Label label = new Label(parent, 0);
        label.setText(Messages.ConnectionProfile);
        this.connectionProfileCtrl = new ConnectionProfileCtrl(parent, 1, "");
        this.connectionProfileCtrl.setUseSynteticValue(false);
        if (this.selectedCP != null) {
            this.connectionProfileCtrl.selectValue(this.selectedCP);
        }
        this.connectionProfileCtrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectConnectionProfileDialog.this.getButton(0).setEnabled(SelectConnectionProfileDialog.this.connectionProfileCtrl.hasConnectionProfileSelected());
                SelectConnectionProfileDialog.this.selectedCP = SelectConnectionProfileDialog.this.connectionProfileCtrl.getSelectedConnectionName();
            }
        });
        return parent;
    }

    public String getConnectionProfileName() {
        return this.selectedCP;
    }
}

