/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.other.internal;

import java.util.HashMap;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveDeltaPreNodeFactory;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeFactory;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackageNode;
import org.jboss.ide.eclipse.archives.core.model.other.internal.INodeProvider;
import org.jboss.ide.eclipse.archives.core.model.other.internal.WorkspaceExtensionManager;

public class WorkspaceNodeFactory
extends ArchiveNodeFactory {
    public IArchiveNode createNode(XbPackageNode node) {
        IArchiveNode sNode = super.createNode(node);
        if (sNode == null) {
            return this.createNodeInternal(node);
        }
        return sNode;
    }

    protected IArchiveNode createNodeInternal(XbPackageNode node) {
        WorkspaceExtensionManager manager = (WorkspaceExtensionManager)ArchivesCore.getInstance().getExtensionManager();
        INodeProvider[] providers = manager.getNodeProviders();
        int i = 0;
        while (i < providers.length) {
            if (providers[i].canCreateNode(node)) {
                return providers[i].createNode(node);
            }
            ++i;
        }
        return null;
    }

    public IArchiveNode createDeltaNode(IArchiveNodeDelta parentDelta, IArchiveNode postChange, HashMap attributeChanges, HashMap propertyChanges) {
        IArchiveNode node = new ArchiveDeltaPreNodeFactory().createNode(parentDelta, postChange, attributeChanges, propertyChanges);
        if (node == null) {
            WorkspaceExtensionManager manager = (WorkspaceExtensionManager)ArchivesCore.getInstance().getExtensionManager();
            INodeProvider[] providers = manager.getNodeProviders();
            int i = 0;
            while (i < providers.length) {
                if (providers[i].canCreateDelta(postChange)) {
                    return providers[i].createDelta(parentDelta, postChange, attributeChanges, propertyChanges);
                }
                ++i;
            }
        }
        return node;
    }
}

