/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.shell.PromptType;

public class PromptTypeConverter {
    private final Instance<Project> projectInstance;

    @Inject
    public PromptTypeConverter(Instance<Project> projectInstance) {
        this.projectInstance = projectInstance;
    }

    public String convert(PromptType promptType, String value) {
        Project project = (Project)this.projectInstance.get();
        if (value != null) {
            if (PromptType.JAVA_CLASS.equals((Object)promptType)) {
                if (value.startsWith("~.") && project != null && project.hasFacet(JavaSourceFacet.class)) {
                    value = value.replaceFirst("~", ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage());
                }
            } else if (PromptType.JAVA_PACKAGE.equals((Object)promptType) && value.startsWith("~.") && project != null && project.hasFacet(JavaSourceFacet.class)) {
                value = value.replaceFirst("~", ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).getBasePackage());
            }
        }
        return value;
    }
}

