/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.plugins;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.jboss.forge.maven.plugins.Configuration;
import org.jboss.forge.maven.plugins.ConfigurationImpl;
import org.jboss.forge.maven.plugins.Execution;
import org.jboss.forge.maven.plugins.ExecutionBuilder;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;

public class MavenPluginAdapter
extends Plugin
implements MavenPlugin {
    private static final long serialVersionUID = 2502801162956631981L;

    public MavenPluginAdapter(MavenPlugin mavenPlugin) {
        Dependency dependency = mavenPlugin.getDependency();
        this.setGroupId(dependency.getGroupId());
        this.setArtifactId(dependency.getArtifactId());
        this.setVersion(dependency.getVersion());
        this.setConfiguration(this.parseConfig(mavenPlugin.getConfig()));
        this.setExecutions(this.transformExecutions(mavenPlugin));
        if (mavenPlugin.isExtensionsEnabled()) {
            this.setExtensions(true);
        }
        this.setDependencies(this.transformDependencies(mavenPlugin));
    }

    private List<org.apache.maven.model.Dependency> transformDependencies(MavenPlugin mavenPlugin) {
        ArrayList<org.apache.maven.model.Dependency> dependencies = new ArrayList<org.apache.maven.model.Dependency>();
        for (Dependency dependency : mavenPlugin.getDirectDependencies()) {
            org.apache.maven.model.Dependency pluginDependency = new org.apache.maven.model.Dependency();
            pluginDependency.setArtifactId(dependency.getArtifactId());
            pluginDependency.setGroupId(dependency.getGroupId());
            pluginDependency.setVersion(dependency.getVersion());
            pluginDependency.setScope(dependency.getScopeType());
            pluginDependency.setExclusions(this.transformExclusions(dependency.getExcludedDependencies()));
            dependencies.add(pluginDependency);
        }
        return dependencies;
    }

    private List<Exclusion> transformExclusions(List<Dependency> excludedDependencies) {
        ArrayList<Exclusion> result = new ArrayList<Exclusion>(excludedDependencies.size());
        for (Dependency dependency : excludedDependencies) {
            Exclusion exclusion = new Exclusion();
            exclusion.setArtifactId(dependency.getArtifactId());
            exclusion.setGroupId(dependency.getGroupId());
            result.add(exclusion);
        }
        return result;
    }

    private List<PluginExecution> transformExecutions(MavenPlugin mavenPlugin) {
        ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
        for (Execution execution : mavenPlugin.listExecutions()) {
            PluginExecution pluginExecution = new PluginExecution();
            pluginExecution.setId(execution.getId());
            pluginExecution.setPhase(execution.getPhase());
            pluginExecution.setGoals(execution.getGoals());
            pluginExecution.setConfiguration((Object)this.parseConfig(execution.getConfig()));
            executions.add(pluginExecution);
        }
        return executions;
    }

    private Xpp3Dom parseConfig(Configuration configuration) {
        if (configuration == null || !configuration.hasConfigurationElements()) {
            return null;
        }
        try {
            return Xpp3DomBuilder.build((InputStream)new ByteArrayInputStream(configuration.toString().getBytes()), (String)"UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception while parsing configuration", ex);
        }
    }

    public MavenPluginAdapter(Plugin plugin) {
        Plugin clone = plugin.clone();
        this.setGroupId(clone.getGroupId());
        this.setArtifactId(clone.getArtifactId());
        this.setVersion(clone.getVersion());
        this.setConfiguration(plugin.getConfiguration());
        this.setExecutions(clone.getExecutions());
        this.setExtensions(clone.getExtensions());
    }

    @Override
    public List<Execution> listExecutions() {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        for (PluginExecution pluginExecution : this.getExecutions()) {
            ExecutionBuilder executionBuilder = ExecutionBuilder.create().setId(pluginExecution.getId()).setPhase(pluginExecution.getPhase());
            for (String goal : pluginExecution.getGoals()) {
                executionBuilder.addGoal(goal);
            }
            if (pluginExecution.getConfiguration() != null) {
                executionBuilder.setConfig(new ConfigurationImpl((Xpp3Dom)pluginExecution.getConfiguration()));
            }
            executions.add(executionBuilder);
        }
        return executions;
    }

    @Override
    public Configuration getConfig() {
        Xpp3Dom dom = (Xpp3Dom)super.getConfiguration();
        return new ConfigurationImpl(dom);
    }

    @Override
    public Dependency getDependency() {
        return DependencyBuilder.create().setGroupId(this.getGroupId()).setArtifactId(this.getArtifactId()).setVersion(this.getVersion());
    }

    @Override
    public boolean isExtensionsEnabled() {
        return this.isExtensions();
    }

    @Override
    public List<Dependency> getDirectDependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (org.apache.maven.model.Dependency pluginDependency : this.getDependencies()) {
            DependencyBuilder builder = DependencyBuilder.create().setArtifactId(pluginDependency.getArtifactId()).setGroupId(pluginDependency.getGroupId()).setVersion(pluginDependency.getVersion()).setPackagingType(pluginDependency.getType()).setScopeType(pluginDependency.getScope());
            dependencies.add((Dependency)builder);
        }
        return dependencies;
    }
}

