/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.jboss.tools.common.core.resources.XModelObjectEditorInput;
import org.jboss.tools.common.editor.ObjectMultiPageEditor;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

class ResourceChangeListener
implements IResourceChangeListener {
    IEditorPart editorPart;
    Composite container;

    ResourceChangeListener(IEditorPart editorPart, Composite container) {
        this.editorPart = editorPart;
        this.container = container;
        IWorkspace workspace = ModelUIPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        workspace.addResourceChangeListener((IResourceChangeListener)this);
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IWorkspace workspace = ModelUIPlugin.getWorkspace();
                if (workspace == null) {
                    return;
                }
                workspace.removeResourceChangeListener((IResourceChangeListener)ResourceChangeListener.this);
            }
        });
    }

    public void resourceChanged(IResourceChangeEvent event) {
        XModelObject p;
        XModelObject o;
        IProject project;
        final IEditorInput ei = this.editorPart.getEditorInput();
        if (!(!(ei instanceof IModelObjectEditorInput) || (project = EclipseResourceUtil.getProject((XModelObject)(o = ((IModelObjectEditorInput)ei).getXModelObject()))) == null || project.exists() && project.isOpen())) {
            this.closeEditor();
            return;
        }
        if (!(ei instanceof IFileEditorInput)) {
            return;
        }
        IFileEditorInput fi = (IFileEditorInput)ei;
        IFile f = fi.getFile();
        if (f == null) {
            return;
        }
        IPath path = this.getPathChange(event, f);
        if (path == null) {
            if (f != null && !f.exists()) {
                this.closeEditor();
            }
            return;
        }
        f = ModelPlugin.getWorkspace().getRoot().getFile(path);
        XModelObject xModelObject = p = f == null ? null : EclipseResourceUtil.getObjectByResource((IResource)f.getParent());
        if (p instanceof FolderImpl) {
            ((FolderImpl)p).update();
        }
        final XModelObject o2 = EclipseResourceUtil.getObjectByResource((IResource)f);
        if (f != null && f.exists() && o2 != null && this.editorPart instanceof ObjectMultiPageEditor) {
            final ObjectMultiPageEditor e = (ObjectMultiPageEditor)this.editorPart;
            if (ei instanceof XModelObjectEditorInput) {
                final IModelObjectEditorInput e2 = XModelObjectEditorInput.createInstance(o2);
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ResourceChangeListener.this.apply(e, o2, ei, e2);
                        }
                    });
                } else {
                    this.apply(e, o2, ei, e2);
                }
            }
        }
        if (f == null || f.exists()) {
            return;
        }
        this.closeEditor();
    }

    void apply(ObjectMultiPageEditor e, XModelObject o, IEditorInput ei, IEditorInput e2) {
        e.setInput(e2);
        e.updateTitle();
        if (e.textEditor instanceof AbstractTextEditor) {
            ((AbstractTextEditor)e.textEditor).setInput(e2);
            ((XModelObjectEditorInput)ei).synchronize();
            if (((XModelObjectEditorInput)ei).getXModelObject() != o) {
                this.closeEditor();
                return;
            }
        }
    }

    private void closeEditor() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourceChangeListener.this.editorPart.getSite().getPage().closeEditor(ResourceChangeListener.this.editorPart, false);
            }
        });
    }

    private IPath getPathChange(IResourceChangeEvent event, IFile f) {
        return this.getPathChange(event.getDelta(), f.getFullPath());
    }

    private IPath getPathChange(IResourceDelta delta, IPath p) {
        if (delta == null || delta.getFullPath() == null) {
            return null;
        }
        if (!delta.getFullPath().isPrefixOf(p)) {
            return null;
        }
        if (delta != null && delta.getKind() == 4) {
            IResourceDelta[] ds = delta.getAffectedChildren();
            if (ds == null) {
                return null;
            }
            if (ds.length > 1) {
                return this.getPathChange(ds, p);
            }
            int i = 0;
            while (i < ds.length) {
                IPath ps = this.getPathChange(ds[i], p);
                if (ps != null) {
                    return ps;
                }
                ++i;
            }
        }
        return null;
    }

    private IPath getPathChange(IResourceDelta[] ds, IPath p) {
        IPath d;
        int index = -1;
        boolean equals = false;
        IPath dp = null;
        int i = 0;
        while (i < ds.length) {
            if (ds[i].getKind() == 2) {
                d = ds[i].getFullPath();
                if (d.equals((Object)p)) {
                    equals = true;
                    index = i;
                    dp = d;
                    break;
                }
                if (d.isPrefixOf(p)) {
                    index = i;
                    dp = d;
                }
            }
            ++i;
        }
        if (index < 0) {
            return null;
        }
        i = 0;
        while (i < ds.length) {
            if (ds[i].getKind() == 1) {
                d = ds[i].getFullPath();
                IPath df = ds[i].getMovedFromPath();
                if (dp.equals((Object)df)) {
                    if (equals) {
                        return d;
                    }
                    return d.append(p.removeFirstSegments(dp.segmentCount()));
                }
            }
            ++i;
        }
        return null;
    }
}

