/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintFileFilter;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;

public class FileChooserAdapter
extends DefaultValueAdapter {
    protected Properties properties;
    private String[] extensions = null;
    private String[] filenames = null;

    @Override
    public void dispose() {
        super.dispose();
        this.properties = null;
    }

    @Override
    public void setAttribute(XAttribute attribute) {
        super.setAttribute(attribute);
        XAttributeConstraintFileFilter c = (XAttributeConstraintFileFilter)attribute.getConstraint();
        this.properties = c.getProperties();
        if (this.properties != null) {
            String s = this.properties.getProperty("extensions");
            StringTokenizer st = new StringTokenizer(s == null ? "" : s, ";,");
            this.extensions = new String[st.countTokens()];
            int i = 0;
            while (i < this.extensions.length) {
                this.extensions[i] = "*." + st.nextToken();
                ++i;
            }
            s = this.properties.getProperty("filenames");
            if (s != null) {
                st = new StringTokenizer(s, ";,");
                this.filenames = new String[st.countTokens()];
                i = 0;
                while (i < this.filenames.length) {
                    this.filenames[i] = st.nextToken();
                    ++i;
                }
                if (this.extensions == null || this.extensions.length == 0) {
                    this.extensions = this.filenames;
                }
            }
        }
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public String[] getFileNames() {
        return this.filenames;
    }

    public String getFilterPath() {
        XAttributeConstraintFileFilter c = (XAttributeConstraintFileFilter)this.attribute.getConstraint();
        this.properties = c.getProperties();
        return this.properties == null ? null : this.properties.getProperty("filterFolder");
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return super.getAdapter(adapter);
    }
}

