/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.jboss.tools.common.propertieseditor.BundleLanguagesEditor;
import org.jboss.tools.common.propertieseditor.BundleLocaleEditor;
import org.jboss.tools.common.propertieseditor.bundlemodel.BundleModel;

public class BundleEditor
extends EditorPart {
    BundleModel bundleModel = new BundleModel();
    BundleLanguagesEditor languages;
    BundleLocaleEditor childrenEditor;
    private ActivationListener fActivationListener = new ActivationListener();
    private boolean fIsSanityCheckEnabled = true;

    public BundleEditor() {
        this.bundleModel.addModifiedListener(new BundleModel.ModificationListener(){

            @Override
            public void changed() {
                BundleEditor.this.firePropertyChange(257);
            }
        });
    }

    public void dispose() {
        super.dispose();
        if (this.fActivationListener != null && this.bundleModel != null) {
            IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
            window.getPartService().removePartListener((IPartListener)this.fActivationListener);
            window.getShell().removeShellListener((ShellListener)this.fActivationListener);
        }
        this.fActivationListener = null;
        if (this.childrenEditor != null) {
            this.childrenEditor.dispose();
        }
        this.childrenEditor = null;
        if (this.bundleModel != null) {
            this.bundleModel.dispose();
        }
        this.bundleModel = null;
        if (this.languages != null) {
            this.languages.dispose();
        }
        this.languages = null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.initializeTitle();
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        window.getPartService().addPartListener((IPartListener)this.fActivationListener);
        window.getShell().addShellListener((ShellListener)this.fActivationListener);
    }

    private void initializeTitle() {
        IFile f = this.getFile();
        String title = null;
        if (f != null) {
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i >= 0) {
                s = s.substring(0, i);
            }
            title = "bundle " + s;
        } else {
            title = this.getEditorInput().getName();
        }
        this.setPartName(title);
        this.setContentDescription(title);
    }

    private IFile getFile() {
        if (this.getEditorInput() instanceof IFileEditorInput) {
            return ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        return null;
    }

    public boolean isDirty() {
        return this.bundleModel.isModified();
    }

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        this.languages = new BundleLanguagesEditor();
        this.languages.setBundleModel(this.bundleModel);
        this.childrenEditor = new BundleLocaleEditor();
        this.childrenEditor.setBundleModel(this.bundleModel);
        IEditorInput input = this.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFile f = ((IFileEditorInput)input).getFile();
            this.bundleModel.setMainFile(f);
            this.bundleModel.load();
        }
        this.childrenEditor.setObject(this.bundleModel.getModelObject());
        Composite p = new Composite(parent, 0);
        p.setLayout((Layout)new GridLayout());
        Control c1 = this.languages.createControl(p);
        c1.setLayoutData((Object)new GridData(768));
        Control c2 = this.childrenEditor.createControl(p);
        c2.setLayoutData((Object)new GridData(1808));
        this.languages.addListener(this.childrenEditor);
    }

    public void doSave(IProgressMonitor monitor) {
        this.bundleModel.save();
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void updateEditableMode() {
        if (this.childrenEditor != null) {
            this.childrenEditor.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableSanityChecking(boolean enable) {
        BundleEditor bundleEditor = this;
        synchronized (bundleEditor) {
            this.fIsSanityCheckEnabled = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safelySanityCheckState(IEditorInput input) {
        boolean enabled = false;
        BundleEditor bundleEditor = this;
        synchronized (bundleEditor) {
            enabled = this.fIsSanityCheckEnabled;
        }
        if (enabled) {
            this.doSanityCheckState(input);
        }
    }

    protected boolean doSanityCheckState(IEditorInput input) {
        IFile iFile;
        if (input instanceof IFileEditorInput && (iFile = ((IFileEditorInput)input).getFile()) == null) {
            return false;
        }
        return false;
    }

    class ActivationListener
    extends ShellAdapter
    implements IPartListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;

        ActivationListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void shellActivated(ShellEvent e) {
            BundleEditor.this.updateEditableMode();
            e.widget.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ActivationListener.this.handleActivation();
                }
            });
        }

        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart != null && this.fActivePart.getSite() == BundleEditor.this.getSite()) {
                this.fIsHandlingActivation = true;
                try {
                    BundleEditor.this.doSanityCheckState(BundleEditor.this.getEditorInput());
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }
    }
}

