/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.dom4j.DocumentException;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Dispatcher;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.LocalDispatcher;
import org.jboss.seam.core.LocalTransactionListener;
import org.jboss.seam.core.TransactionListener;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Resources;

@Scope(value=ScopeType.STATELESS)
@Intercept(value=InterceptionType.NEVER)
@Name(value="org.jboss.seam.core.events")
@Install(precedence=0)
public class Events {
    private static final LogProvider log = Logging.getLogProvider(Events.class);

    @Create
    public void initialize() throws DocumentException {
        InputStream stream = Resources.getResourceAsStream("/WEB-INF/events.xml");
        if (stream == null) {
            log.info("no events.xml file found");
        } else {
            log.info("reading events.xml");
        }
    }

    public void addListener(String type, String methodBindingExpression) {
        Expressions.MethodBinding methodBinding = Expressions.instance().createMethodBinding(methodBindingExpression);
        Init.instance().addObserverMethodBinding(type, methodBinding);
    }

    public void raiseEvent(String type, Object ... parameters) {
        List<Init.ObserverMethod> observers;
        log.debug("Processing event:" + type);
        List<Init.ObserverMethodBinding> list = Init.instance().getObserverMethodBindings(type);
        if (list != null) {
            for (Init.ObserverMethodBinding listener : list) {
                listener.getMethodBinding().invoke(parameters);
            }
        }
        if ((observers = Init.instance().getObserverMethods(type)) != null) {
            for (Init.ObserverMethod observer : observers) {
                Object listener = Component.getInstance(observer.getComponent().getName(), observer.isCreate());
                if (listener == null) continue;
                observer.getComponent().callComponentMethod(listener, observer.getMethod(), parameters);
            }
        }
    }

    public void raiseAsynchronousEvent(String type, Object ... parameters) {
        this.getDispatcher().scheduleEvent(type, 0L, null, null, parameters);
    }

    protected LocalDispatcher getDispatcher() {
        LocalDispatcher dispatcher = Dispatcher.instance();
        if (dispatcher == null) {
            throw new IllegalStateException("org.jboss.seam.core.dispatcher is not installed");
        }
        return dispatcher;
    }

    public void raiseTransactionSuccessEvent(String type, Object ... parameters) {
        LocalTransactionListener transactionListener = TransactionListener.instance();
        if (transactionListener == null) {
            throw new IllegalStateException("org.jboss.seam.core.transactionListener is not installed");
        }
        transactionListener.scheduleEvent(type, parameters);
    }

    public void raiseTimedEvent(String type, long duration, Object ... parameters) {
        this.getDispatcher().scheduleEvent(type, duration, null, null, parameters);
    }

    public void raiseTimedEvent(String type, Date expiration, Object ... parameters) {
        this.getDispatcher().scheduleEvent(type, null, expiration, null, parameters);
    }

    public void raiseTimedEvent(String type, Date expiration, long intervalDuration, Object ... parameters) {
        this.getDispatcher().scheduleEvent(type, null, expiration, intervalDuration, parameters);
    }

    public void raiseTimedEvent(String type, long duration, long intervalDuration) {
        this.getDispatcher().scheduleEvent(type, duration, null, intervalDuration, new Object[0]);
    }

    public static boolean exists() {
        return Contexts.isApplicationContextActive() && Events.instance() != null;
    }

    public static Events instance() {
        return (Events)Component.getInstance(Events.class, ScopeType.STATELESS);
    }
}

