/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.cache;

import java.util.Map;
import org.ajax4jsf.cache.Cache;
import org.ajax4jsf.cache.CacheFactory;
import org.ajax4jsf.cache.LRUMapCache;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUMapCacheFactory
implements CacheFactory {
    private static final Logger log = RichfacesLogger.CACHE.getLogger();
    public static final String CACHE_SIZE_PARAMETER = "org.ajax4jsf.cache.LRU_MAP_CACHE_SIZE";

    public Cache createCache(Map<?, ?> env) {
        log.info("Creating LRUMap cache instance using parameters: " + env);
        String size = (String)env.get(CACHE_SIZE_PARAMETER);
        if (size == null || size.length() == 0) {
            log.info("Creating LRUMap cache instance of default capacity");
            return new LRUMapCache();
        }
        int parsedSize = Integer.parseInt(size);
        log.info("Creating LRUMap cache instance of " + parsedSize + " items capacity");
        return new LRUMapCache(parsedSize);
    }
}

