/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.resource;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.imageio.ImageIO;
import org.ajax4jsf.util.NumericDataInputStream;
import org.ajax4jsf.util.NumericDataOutputStream;
import org.richfaces.resource.AbstractBaseResource;

public abstract class Java2Dresource
extends AbstractBaseResource
implements StateHolder {
    private ImageType imageType;

    public Java2Dresource(ImageType imageType) {
        this.imageType = imageType;
    }

    public abstract Dimension getDimension();

    protected void paint(Graphics2D graphics2D, Dimension dimension) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() {
        Dimension dimension = this.getDimension();
        int width = dimension.width;
        int height = dimension.height;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (width > 0 && height > 0) {
            BufferedImage image = this.imageType.createImage(width, height);
            Graphics2D g2d = image.createGraphics();
            try {
                this.paint(g2d, dimension);
            }
            finally {
                g2d.dispose();
            }
            try {
                ImageIO.write((RenderedImage)image, this.imageType.getFormatName(), baos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public String getContentType() {
        return this.imageType.getMimeType();
    }

    protected void writeState(FacesContext context, NumericDataOutputStream stream) {
    }

    protected void readState(FacesContext context, NumericDataInputStream stream) {
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        this.readState(context, new NumericDataInputStream((byte[])state));
    }

    public Object saveState(FacesContext context) {
        NumericDataOutputStream stream = new NumericDataOutputStream();
        this.writeState(context, stream);
        return stream.getBytes();
    }

    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        GIF("gif"){

            public BufferedImage createImage(int width, int height) {
                return ImageType.createARGBImage(width, height);
            }
        }
        ,
        PNG("png"){

            public BufferedImage createImage(int width, int height) {
                return ImageType.createARGBImage(width, height);
            }
        }
        ,
        PNG8("png"){

            public BufferedImage createImage(int width, int height) {
                return new BufferedImage(width, height, 13, SAFE_WEB_COLORS_MODEL);
            }
        }
        ,
        JPEG("jpeg"){

            public BufferedImage createImage(int width, int height) {
                return new BufferedImage(width, height, 1);
            }
        };

        protected static final IndexColorModel SAFE_WEB_COLORS_MODEL;
        private String formatName;
        private String mimeType;

        private static BufferedImage createARGBImage(int width, int height) {
            return new BufferedImage(width, height, 2);
        }

        private ImageType(String formatName) {
            this.formatName = formatName;
            this.mimeType = "image/" + formatName;
        }

        protected abstract BufferedImage createImage(int var1, int var2);

        protected String getFormatName() {
            return this.formatName;
        }

        protected String getMimeType() {
            return this.mimeType;
        }

        static {
            byte[] webLevels = new byte[]{0, 51, 102, -103, -52, -1};
            int colorsNumber = webLevels.length * webLevels.length * webLevels.length;
            byte[] r = new byte[colorsNumber];
            byte[] g = new byte[colorsNumber];
            byte[] b = new byte[colorsNumber];
            b[0] = 0;
            g[0] = 0;
            r[0] = 0;
            for (int i = 0; i < webLevels.length; ++i) {
                for (int j = 0; j < webLevels.length; ++j) {
                    for (int k = 0; k < webLevels.length; ++k) {
                        int colorNum = i * webLevels.length * webLevels.length + j * webLevels.length + k;
                        r[colorNum] = webLevels[i];
                        g[colorNum] = webLevels[j];
                        b[colorNum] = webLevels[k];
                    }
                }
            }
            SAFE_WEB_COLORS_MODEL = new IndexColorModel(8, colorsNumber, r, g, b, 0);
        }
    }
}

