/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.PhaseId;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.ajax4jsf.framework.ajax.AjaxContainer;
import org.ajax4jsf.framework.ajax.AjaxViewRoot;
import org.ajax4jsf.framework.ajax.ComponentInvoker;
import org.ajax4jsf.framework.ajax.InvokerCallback;
import org.ajax4jsf.framework.ajax.JsfOneOneInvoker;
import org.ajax4jsf.framework.ajax.ViewIdHolder;
import org.ajax4jsf.framework.ajax.xmlfilter.FilterServletResponseWrapper;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.HeaderResourceProducer;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.skin.SkinNotFoundException;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxContext {
    public static final String AJAX_CONTEXT_KEY = "ajaxContext";
    public static final String SCRIPTS_PARAMETER = "org.ajax4jsf.framework.HEADER_SCRIPTS";
    public static final String STYLES_PARAMETER = "org.ajax4jsf.framework.HEADER_STYLES";
    public static final String RESOURCES_PROCESSED = "org.ajax4jsf.framework.HEADER_PROCESSED";
    public static final String RESPONSE_DATA_KEY = "_ajax:data";
    private static final Log log = LogFactory.getLog((Class)AjaxContext.class);
    private static ComponentInvoker invoker;
    private static Map contextClasses;
    Set ajaxAreasToRender = new HashSet();
    Set ajaxRenderedAreas = new HashSet();
    boolean ajaxRequest = false;
    boolean ajaxRequestSet = false;
    boolean selfRender = false;
    Integer viewSequence = new Integer(1);
    String submittedRegionClientId = null;
    boolean submittedRegionSet = false;
    ViewIdHolder viewIdHolder = null;
    Map responseDataMap = new HashMap();
    private InvokerCallback _ajaxInvoker = new InvokerCallback(){

        public void invoke(FacesContext context, UIComponent component) {
            if (component instanceof AjaxContainer) {
                AjaxContainer ajax = (AjaxContainer)component;
                AjaxContext.this.renderAjaxRegion(context, component, true);
            } else {
                AjaxContext.this.renderAjaxRegion(context, (UIComponent)context.getViewRoot(), true);
            }
        }

        public void invokeRoot(FacesContext context) {
            AjaxContext.this.renderAjaxRegion(context, (UIComponent)context.getViewRoot(), true);
        }
    };

    public static AjaxContext getCurrentInstance() {
        FacesContext context = FacesContext.getCurrentInstance();
        return AjaxContext.getCurrentInstance(context);
    }

    public static AjaxContext getCurrentInstance(FacesContext context) {
        if (null == context) {
            throw new NullPointerException("FacesContext is null");
        }
        AjaxContext ajaxContext = (AjaxContext)context.getApplication().getVariableResolver().resolveVariable(context, AJAX_CONTEXT_KEY);
        return ajaxContext;
    }

    public static boolean invokeOnComponent(UIComponent root, FacesContext context, InvokerCallback callback, String regionId) {
        return invoker.invokeOnComponent(root, context, callback, regionId);
    }

    public static void invokeOnRegionOrRoot(AjaxViewRoot viewRoot, FacesContext context, InvokerCallback callback, PhaseId phase) {
        invoker.invokeOnRegionOrRoot(viewRoot, context, callback, phase);
    }

    public void renderSubmittedAjaxRegion(FacesContext context) {
        this.renderSubmittedAjaxRegion(context, true);
    }

    public void renderSubmittedAjaxRegion(FacesContext context, final boolean useFilterWriter) {
        InvokerCallback ajaxInvoker = new InvokerCallback(){

            public void invoke(FacesContext context, UIComponent component) {
                if (component instanceof AjaxContainer) {
                    AjaxContext.this.renderAjaxRegion(context, component, useFilterWriter);
                } else {
                    AjaxContext.this.renderAjaxRegion(context, (UIComponent)context.getViewRoot(), useFilterWriter);
                }
            }

            public void invokeRoot(FacesContext context) {
                AjaxContext.this.renderAjaxRegion(context, (UIComponent)context.getViewRoot(), useFilterWriter);
            }
        };
        if (!AjaxContext.invokeOnComponent((UIComponent)context.getViewRoot(), context, ajaxInvoker, this.getSubmittedRegionClientId(context))) {
            this.renderAjaxRegion(context, (UIComponent)context.getViewRoot(), useFilterWriter);
        }
    }

    public void renderAjaxRegion(FacesContext context, UIComponent component, boolean useFilterWriter) throws FacesException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.RENDER_AJAX_REQUEST, component.getId()));
        }
        try {
            PrintWriter servletWriter;
            String encoding;
            this.setSelfRender(true);
            ExternalContext extContext = context.getExternalContext();
            RenderKit renderKit = context.getRenderKit();
            if (extContext.getRequest() instanceof ServletRequest) {
                ServletRequest request = (ServletRequest)extContext.getRequest();
                ServletResponse response = (ServletResponse)extContext.getResponse();
                String contentType = "text/xml";
                encoding = request.getCharacterEncoding();
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                response.setContentType(contentType + ";charset=" + encoding);
            } else {
                encoding = "UTF-8";
            }
            if (useFilterWriter && extContext.getRequestMap().containsKey("com.exade.vcp.Filter.ResponseWrapper")) {
                ServletResponse servletResponse = (ServletResponse)extContext.getRequestMap().get("com.exade.vcp.Filter.ResponseWrapper");
                servletResponse.resetBuffer();
                servletWriter = servletResponse.getWriter();
                ((FilterServletResponseWrapper)servletResponse).setUseNullStream(true);
            } else {
                servletWriter = this.getWriter(extContext);
            }
            ResponseWriter writer = renderKit.createResponseWriter((Writer)servletWriter, null, encoding);
            context.setResponseWriter(writer);
            writer.startDocument();
            this.encodeAjaxBegin(context, component);
            component.encodeBegin(context);
            ((AjaxContainer)component).encodeAjax(context);
            component.encodeEnd(context);
            this.saveViewState(context);
            this.encodeAjaxEnd(context, component);
            writer.endDocument();
            writer.flush();
            writer.close();
            servletWriter.close();
        }
        catch (IOException e) {
            throw new FacesException(Messages.getMessage(Messages.RENDERING_AJAX_REGION_ERROR, component.getClientId(context)), (Throwable)e);
        }
        finally {
            context.responseComplete();
        }
    }

    public void encodeAjaxBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("html", component);
        Locale locale = context.getViewRoot().getLocale();
        out.writeAttribute("lang", (Object)locale.toString(), "lang");
        out.startElement("body", component);
    }

    public void encodeAjaxEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.endElement("body");
        out.endElement("html");
    }

    public void processHeadResources(FacesContext context) throws FacesException {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        if (!Boolean.TRUE.equals(requestMap.get(RESOURCES_PROCESSED)) && null != requestMap.get("com.exade.vcp.Filter.ResponseWrapper")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Process component tree for collect used scripts and styles");
            }
            UIViewRoot root = context.getViewRoot();
            LinkedHashSet scripts = new LinkedHashSet();
            LinkedHashSet<String> styles = new LinkedHashSet<String>();
            RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            RenderKit renderKit = rkFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
            this.processHeadResources(context, (UIComponent)root, scripts, styles, renderKit);
            if (scripts.size() > 0) {
                if (log.isDebugEnabled()) {
                    StringBuffer buff = new StringBuffer("Scripts for insert into head : \n");
                    Iterator iter = scripts.iterator();
                    while (iter.hasNext()) {
                        String script = (String)iter.next();
                        buff.append(script).append("\n");
                    }
                    log.debug((Object)buff.toString());
                }
                requestMap.put(SCRIPTS_PARAMETER, scripts);
            }
            String styleSheetUri = null;
            try {
                styleSheetUri = (String)SkinFactory.getInstance().getSkin(context).getParameter(context, "generalStyleSheet");
            }
            catch (SkinNotFoundException e) {
                log.warn((Object)"Current Skin is not found", (Throwable)((Object)e));
            }
            if (null != styleSheetUri) {
                String resourceURL = context.getApplication().getViewHandler().getResourceURL(context, styleSheetUri);
                styles.add(resourceURL);
            }
            if (styles.size() > 0) {
                if (log.isDebugEnabled()) {
                    StringBuffer buff = new StringBuffer("Styles for insert into head : \n");
                    Iterator iter = styles.iterator();
                    while (iter.hasNext()) {
                        String style = (String)iter.next();
                        buff.append(style).append("\n");
                    }
                    log.debug((Object)buff.toString());
                }
                requestMap.put(STYLES_PARAMETER, styles);
            }
            requestMap.put(RESOURCES_PROCESSED, Boolean.TRUE);
        }
    }

    private void processHeadResources(FacesContext context, UIComponent root, Set scripts, Set styles, RenderKit renderKit) {
        UIComponent child;
        Renderer renderer = this.getRenderer(context, root, renderKit);
        if (null != renderer && renderer instanceof HeaderResourceProducer) {
            HeaderResourceProducer producer = (HeaderResourceProducer)renderer;
            LinkedHashSet set = producer.getHeaderScripts(context, root);
            if (null != set) {
                scripts.addAll(set);
            }
            if (null != (set = producer.getHeaderStyles(context, root))) {
                styles.addAll(set);
            }
        }
        Iterator<Object> iter = root.getFacets().values().iterator();
        while (iter.hasNext()) {
            child = (UIComponent)iter.next();
            this.processHeadResources(context, child, scripts, styles, renderKit);
        }
        iter = root.getChildren().iterator();
        while (iter.hasNext()) {
            child = (UIComponent)iter.next();
            this.processHeadResources(context, child, scripts, styles, renderKit);
        }
    }

    private Renderer getRenderer(FacesContext context, UIComponent comp, RenderKit renderKit) {
        String rendererType = comp.getRendererType();
        if (rendererType != null) {
            return renderKit.getRenderer(comp.getFamily(), rendererType);
        }
        return null;
    }

    public void saveViewState(FacesContext context) throws IOException {
        try {
            Application.class.getMethod("getExpressionFactory", null);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        ResponseWriter writer = context.getResponseWriter();
        StateManager stateManager = context.getApplication().getStateManager();
        StateManager.SerializedView serializedView = stateManager.saveSerializedView(context);
        if (null != serializedView) {
            StringWriter bufWriter = new StringWriter();
            ResponseWriter cloneWithWriter = writer.cloneWithWriter((Writer)bufWriter);
            context.setResponseWriter(cloneWithWriter);
            stateManager.writeState(context, serializedView);
            cloneWithWriter.flush();
            if (bufWriter.getBuffer().length() > 0) {
                context.getExternalContext().getRequestMap().put("org.ajax4jsf.view.serializedstate", bufWriter.toString());
            }
            context.setResponseWriter(writer);
        }
    }

    public boolean isAjaxRequest() {
        return this.isAjaxRequest(FacesContext.getCurrentInstance());
    }

    public boolean isAjaxRequest(FacesContext context) {
        if (!this.ajaxRequestSet) {
            this.ajaxRequest = null != this.getSubmittedRegionClientId(context);
            this.ajaxRequestSet = true;
        }
        return this.ajaxRequest;
    }

    public void setAjaxRequest(boolean ajaxRequest) {
        this.ajaxRequest = ajaxRequest;
        this.ajaxRequestSet = true;
    }

    public Set getAjaxAreasToRender() {
        return this.ajaxAreasToRender;
    }

    public void addComponentToAjaxRender(UIComponent component) {
        this.ajaxAreasToRender.add(AjaxRendererUtils.getAbsoluteId(component));
    }

    public void addComponentToAjaxRender(UIComponent base, String id) {
        this.ajaxAreasToRender.add(this.convertId(base, id));
    }

    public Set getAjaxRenderedAreas() {
        return this.ajaxRenderedAreas;
    }

    public void addRenderedArea(String id) {
        this.ajaxRenderedAreas.add(id);
    }

    public boolean removeRenderedArea(String id) {
        return this.ajaxRenderedAreas.remove(id);
    }

    public String getSubmittedRegionClientId(FacesContext context) {
        if (!this.submittedRegionSet) {
            this.submittedRegionClientId = (String)context.getExternalContext().getRequestParameterMap().get("AJAXREQUEST");
            this.submittedRegionSet = true;
            if (!this.ajaxRequestSet) {
                this.setAjaxRequest(this.submittedRegionClientId != null);
            }
        }
        return this.submittedRegionClientId;
    }

    public void setSubmittedRegionClientId(String submittedClientId) {
        this.submittedRegionClientId = submittedClientId;
        this.submittedRegionSet = true;
    }

    public boolean isSelfRender() {
        return this.selfRender;
    }

    public void setSelfRender(boolean selfRender) {
        this.selfRender = selfRender;
    }

    public ViewIdHolder getViewIdHolder() {
        return this.viewIdHolder;
    }

    public void setViewIdHolder(ViewIdHolder viewIdHolder) {
        this.viewIdHolder = viewIdHolder;
    }

    public Object getResponseData() {
        return this.responseDataMap.get(RESPONSE_DATA_KEY);
    }

    public void setResponseData(Object responseData) {
        this.responseDataMap.put(RESPONSE_DATA_KEY, responseData);
    }

    public Map getResponseDataMap() {
        return this.responseDataMap;
    }

    protected PrintWriter getWriter(ExternalContext extContext) throws FacesException {
        PrintWriter writer = null;
        Object response = extContext.getResponse();
        try {
            Method gW = response.getClass().getMethod("getWriter", new Class[0]);
            writer = (PrintWriter)gW.invoke(response, new Object[0]);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        return writer;
    }

    public void addRegionsFromComponent(UIComponent component) {
        Set ajaxRegions = AjaxRendererUtils.getAjaxAreas(component);
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage(Messages.INVOKE_AJAX_REGION_LISTENER, component.getId()));
        }
        if (ajaxRegions != null) {
            Iterator iter = ajaxRegions.iterator();
            while (iter.hasNext()) {
                String id = iter.next().toString();
                this.ajaxAreasToRender.add(this.convertId(component, id));
            }
        }
    }

    private String convertId(UIComponent component, String id) {
        UIComponent target;
        if (id.charAt(0) == ':') {
            return id;
        }
        if (null != component && null != (target = component.findComponent(id))) {
            return AjaxRendererUtils.getAbsoluteId(target);
        }
        return id;
    }

    static {
        contextClasses = new HashMap();
        try {
            invoker = new JsfOneOneInvoker();
        }
        catch (Exception e) {
            invoker = new JsfOneOneInvoker();
        }
    }
}

