/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.ArrayList;
import java.util.List;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.pbcast.NAKACK;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class LastMessageDroppedTest
extends ChannelTestBase {
    JChannel c1;
    JChannel c2;

    protected void setUp() throws Exception {
        super.setUp();
        this.c1 = this.createChannel();
        this.c2 = this.createChannel();
        LastMessageDroppedTest.modifyStack(this.c1, this.c2);
        this.c1.connect("LastMessageDroppedTest");
        this.c2.connect("LastMessageDroppedTest");
        View view = this.c2.getView();
        System.out.println("view = " + view);
        LastMessageDroppedTest.assertEquals((String)("view is " + view), (int)2, (int)view.size());
    }

    protected void tearDown() throws Exception {
        Util.close(this.c2, this.c1);
        super.tearDown();
    }

    public void testLastMessageDropped() throws Exception {
        DISCARD discard = new DISCARD();
        ProtocolStack stack = this.c1.getProtocolStack();
        stack.insertProtocol((Protocol)discard, 2, NAKACK.class);
        this.c1.setOpt(3, false);
        Message m1 = new Message(null, null, Integer.valueOf(1));
        Message m2 = new Message(null, null, Integer.valueOf(2));
        Message m3 = new Message(null, null, Integer.valueOf(3));
        MyReceiver receiver = new MyReceiver();
        this.c2.setReceiver(receiver);
        this.c1.send(m1);
        this.c1.send(m2);
        discard.setDropDownMulticasts(1);
        this.c1.send(m3);
        Util.sleep(100L);
        List<Integer> list = receiver.getMsgs();
        for (int i = 0; i < 10; ++i) {
            System.out.println("list=" + list);
            if (list.size() == 3) break;
            Util.sleep(1000L);
        }
        LastMessageDroppedTest.assertEquals((String)("list=" + list), (int)3, (int)list.size());
    }

    private static void modifyStack(JChannel ... channels) {
        for (JChannel ch : channels) {
            ProtocolStack stack = ch.getProtocolStack();
            STABLE stable = (STABLE)stack.findProtocol(STABLE.class);
            if (stable == null) {
                throw new IllegalStateException("STABLE protocol was not found");
            }
            stable.setDesiredAverageGossip(2000L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyReceiver
    extends ReceiverAdapter {
        private final List<Integer> msgs = new ArrayList<Integer>(3);

        private MyReceiver() {
        }

        public List<Integer> getMsgs() {
            return this.msgs;
        }

        @Override
        public void receive(Message msg) {
            this.msgs.add((Integer)msg.getObject());
        }
    }
}

