/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.HeaderResourcesRendererBase;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.richfaces.component.UIDatascroller;
import org.richfaces.event.DataScrollerEvent;

public class DataScrollerRenderer
extends HeaderResourcesRendererBase {
    private static final String PARAM_SUFFIX = "_parameter";
    static /* synthetic */ Class class$org$richfaces$component$UIDatascroller;

    protected Class getComponentClass() {
        return class$org$richfaces$component$UIDatascroller == null ? (class$org$richfaces$component$UIDatascroller = DataScrollerRenderer.class$("org.richfaces.component.UIDatascroller")) : class$org$richfaces$component$UIDatascroller;
    }

    public void decode(FacesContext context, UIComponent component) {
        String param = (String)this.getParamMap(context).get(component.getClientId(context) + PARAM_SUFFIX);
        if (param != null) {
            UIDatascroller scroller = (UIDatascroller)component;
            scroller.setPage(param);
            scroller.getPageIndex();
            String oldScrolVal = scroller.getHandleValue();
            String newScrolVal = Integer.toString(scroller.getPageIndex());
            if (!newScrolVal.equals(oldScrolVal)) {
                scroller.setHandleValue(newScrolVal);
                DataScrollerEvent event = new DataScrollerEvent((UIComponent)scroller, oldScrolVal, newScrolVal);
                event.queue();
                AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)component, (String)component.getId());
                AjaxRendererUtils.addRegionByName((FacesContext)context, (UIComponent)component, (String)scroller.getFor());
            }
        }
    }

    public void renderPager(FacesContext context, UIComponent component) throws IOException {
        int start;
        int pages;
        int pageCount;
        ResponseWriter out = context.getResponseWriter();
        UIDatascroller scroller = (UIDatascroller)component;
        int currentPage = scroller.getPageIndex();
        int maxPages = scroller.getMaxPages();
        if (maxPages <= 1) {
            maxPages = 2;
        }
        if ((pageCount = scroller.getPageCount()) <= 1) {
            return;
        }
        int pageIndex = scroller.getPageIndex();
        int delta = maxPages / 2;
        if (pageCount > maxPages && pageIndex > delta) {
            pages = maxPages;
            start = pageIndex - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        int i = start;
        int size = start + pages;
        int j = 1;
        while (i < size) {
            boolean isCurrentPage = i + 1 == currentPage;
            out.startElement("td", component);
            if (isCurrentPage) {
                out.writeAttribute("align", (Object)"center", null);
                out.writeAttribute("class", (Object)"dr-dscr-act rich-datascr-act", null);
                out.writeAttribute("style", (Object)("" + scroller.getSelectedStyle()), null);
            } else {
                out.writeAttribute("align", (Object)"center", null);
                out.writeAttribute("class", (Object)"dr-dscr-inact rich-datascr-inact", null);
                out.writeAttribute("onclick", (Object)this.getOnClick(context, component, Integer.toString(j)), null);
            }
            out.writeText((Object)Integer.toString(i + 1), null);
            out.endElement("td");
            ++i;
            ++j;
        }
    }

    private Map getParamMap(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap();
    }

    public String getOnClick(FacesContext context, UIComponent component, String value) {
        JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)component, (FacesContext)context);
        UIDatascroller scroller = (UIDatascroller)component;
        Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)component);
        Map parameters = (Map)eventOptions.get("parameters");
        parameters.put(scroller.getClientId(context) + PARAM_SUFFIX, value);
        function.addParameter((Object)eventOptions);
        StringBuffer buffer = new StringBuffer();
        function.appendScript(buffer);
        buffer.append("; return false;");
        String script = buffer.toString();
        return script;
    }

    public boolean getRendersChildren() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

