/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.xa;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.resource.adapter.jdbc.xa.XAManagedConnection;

public class XAManagedConnectionFactory
extends BaseWrapperManagedConnectionFactory {
    private static final long serialVersionUID = 1647927657609573729L;
    private String xaDataSourceClass;
    private String xaDataSourceProperties;
    protected final Properties xaProps = new Properties();
    private Boolean isSameRMOverrideValue;
    private XADataSource xads;
    static /* synthetic */ Class class$java$lang$String;

    public String getXADataSourceClass() {
        return this.xaDataSourceClass;
    }

    public void setXADataSourceClass(String xaDataSourceClass) {
        this.xaDataSourceClass = xaDataSourceClass;
    }

    public String getXADataSourceProperties() {
        return this.xaDataSourceProperties;
    }

    public void setXADataSourceProperties(String xaDataSourceProperties) throws ResourceException {
        this.xaDataSourceProperties = xaDataSourceProperties;
        this.xaProps.clear();
        if (xaDataSourceProperties != null) {
            xaDataSourceProperties = xaDataSourceProperties.replaceAll("\\\\", "\\\\\\\\");
            ByteArrayInputStream is = new ByteArrayInputStream(xaDataSourceProperties.getBytes());
            try {
                this.xaProps.load(is);
            }
            catch (IOException ioe) {
                throw new JBossResourceException("Could not load connection properties", ioe);
            }
        }
    }

    public Boolean getIsSameRMOverrideValue() {
        return this.isSameRMOverrideValue;
    }

    public void setIsSameRMOverrideValue(Boolean isSameRMOverrideValue) {
        this.isSameRMOverrideValue = isSameRMOverrideValue;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties props = this.getConnectionProperties(subject, cri);
        try {
            String user = props.getProperty("user");
            String password = props.getProperty("password");
            XAConnection xaConnection = user != null ? this.getXADataSource().getXAConnection(user, password) : this.getXADataSource().getXAConnection();
            return this.newXAManagedConnection(props, xaConnection);
        }
        catch (Exception e) {
            throw new JBossResourceException("Could not create connection", e);
        }
    }

    protected ManagedConnection newXAManagedConnection(Properties props, XAConnection xaConnection) throws SQLException {
        return new XAManagedConnection(this, xaConnection, props, this.transactionIsolation, this.preparedStatementCacheSize);
    }

    public ManagedConnection matchManagedConnections(Set mcs, Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.getConnectionProperties(subject, cri);
        Iterator i = mcs.iterator();
        while (i.hasNext()) {
            XAManagedConnection mc;
            Object o = i.next();
            if (!(o instanceof XAManagedConnection) || !(mc = (XAManagedConnection)o).getProps().equals(newProps) || (!this.getValidateOnMatch() || !mc.checkValid()) && this.getValidateOnMatch()) continue;
            return mc;
        }
        return null;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.xaDataSourceClass == null ? 0 : this.xaDataSourceClass.hashCode());
        result = result * 37 + this.xaProps.hashCode();
        result = result * 37 + (this.userName == null ? 0 : this.userName.hashCode());
        result = result * 37 + (this.password == null ? 0 : this.password.hashCode());
        result = result * 37 + this.transactionIsolation;
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        XAManagedConnectionFactory otherMcf = (XAManagedConnectionFactory)other;
        return this.xaDataSourceClass.equals(otherMcf.xaDataSourceClass) && this.xaProps.equals(otherMcf.xaProps) && (this.userName == null ? otherMcf.userName == null : this.userName.equals(otherMcf.userName)) && (this.password == null ? otherMcf.password == null : this.password.equals(otherMcf.password)) && this.transactionIsolation == otherMcf.transactionIsolation;
    }

    protected synchronized XADataSource getXADataSource() throws ResourceException {
        if (this.xads == null) {
            if (this.xaDataSourceClass == null) {
                throw new JBossResourceException("No XADataSourceClass supplied!");
            }
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.xaDataSourceClass);
                this.xads = (XADataSource)clazz.newInstance();
                Class[] NOCLASSES = new Class[]{};
                Iterator<Object> i = this.xaProps.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    String value = this.xaProps.getProperty(name);
                    Class<?> type = null;
                    try {
                        Method getter = clazz.getMethod("get" + name, NOCLASSES);
                        type = getter.getReturnType();
                    }
                    catch (NoSuchMethodException e) {
                        type = class$java$lang$String == null ? XAManagedConnectionFactory.class$("java.lang.String") : class$java$lang$String;
                    }
                    Method setter = clazz.getMethod("set" + name, type);
                    PropertyEditor editor = PropertyEditorManager.findEditor(type);
                    if (editor == null) {
                        throw new JBossResourceException("No property editor found for type: " + type);
                    }
                    editor.setAsText(value);
                    setter.invoke((Object)this.xads, editor.getValue());
                }
            }
            catch (ClassNotFoundException cnfe) {
                throw new JBossResourceException("Class not found for XADataSource " + this.xaDataSourceClass, cnfe);
            }
            catch (InstantiationException ie) {
                throw new JBossResourceException("Could not create an XADataSource: ", ie);
            }
            catch (IllegalAccessException iae) {
                throw new JBossResourceException("Could not set a property: ", iae);
            }
            catch (IllegalArgumentException iae) {
                throw new JBossResourceException("Could not set a property: ", iae);
            }
            catch (InvocationTargetException ite) {
                throw new JBossResourceException("Could not invoke setter on XADataSource: ", ite);
            }
            catch (NoSuchMethodException nsme) {
                throw new JBossResourceException("Could not find accessor on XADataSource: ", nsme);
            }
        }
        return this.xads;
    }

    protected Properties getXaProps() {
        return this.xaProps;
    }
}

