/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import javax.servlet.ServletContext;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.contexts.Lifecycle;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Startup(depends={"org.jboss.seam.ioc.spring.springELResolver"})
@Name(value="org.jboss.seam.ioc.spring.contextLoader")
@Install(value=false, precedence=0)
public class ContextLoader {
    private WebApplicationContext webApplicationContext;
    private String[] configLocations = new String[]{"/WEB-INF/applicationContext.xml"};

    @Create
    public void create() throws Exception {
        ServletContext servletContext = Lifecycle.getServletContext();
        try {
            this.webApplicationContext = this.createContextLoader(servletContext);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.webApplicationContext);
            this.startupContextLoader(this.webApplicationContext);
        }
        catch (Exception e) {
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)e);
            throw e;
        }
    }

    protected WebApplicationContext createContextLoader(ServletContext servletContext) {
        XmlWebApplicationContext xmlWebApplicationContext = new XmlWebApplicationContext();
        xmlWebApplicationContext.setServletContext(servletContext);
        xmlWebApplicationContext.setConfigLocations(this.getConfigLocations());
        return xmlWebApplicationContext;
    }

    protected void startupContextLoader(WebApplicationContext webApplicationContext) {
        if (webApplicationContext instanceof ConfigurableWebApplicationContext) {
            ((ConfigurableWebApplicationContext)webApplicationContext).refresh();
        }
    }

    @Destroy
    public void destroy() {
        if (this.webApplicationContext != null && this.webApplicationContext instanceof ConfigurableWebApplicationContext) {
            ((ConfigurableWebApplicationContext)this.webApplicationContext).close();
        }
    }

    public String[] getConfigLocations() {
        return this.configLocations;
    }

    public void setConfigLocations(String[] configLocations) {
        this.configLocations = configLocations;
    }
}

