/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueSender;
import javax.naming.NamingException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.jms.QueueSession;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.EVENT)
@BypassInterceptors
public class ManagedQueueSender {
    private String queueJndiName;
    private QueueSender queueSender;

    public String getQueueJndiName() {
        return this.queueJndiName;
    }

    public void setQueueJndiName(String jndiName) {
        this.queueJndiName = jndiName;
    }

    public Queue getQueue() throws NamingException {
        return (Queue)Naming.getInitialContext().lookup(this.queueJndiName);
    }

    @Create
    public void create() throws JMSException, NamingException {
        this.queueSender = QueueSession.instance().createSender(this.getQueue());
    }

    @Destroy
    public void destroy() throws JMSException {
        this.queueSender.close();
    }

    @Unwrap
    public QueueSender getQueueSender() {
        return this.queueSender;
    }

    public String toString() {
        return "TopicConnection(" + this.queueJndiName + ")";
    }
}

