/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.util.Hashtable;
import java.util.Locale;
import org.hibernate.validator.ClassValidator;
import org.jboss.seam.Entity;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    private Class<?> beanClass;
    private Hashtable<Locale, ClassValidator> validators = new Hashtable();

    public Model(Class<?> beanClass) {
        this.beanClass = beanClass;
    }

    public final Class<?> getBeanClass() {
        return this.beanClass;
    }

    public ClassValidator getValidator() {
        java.util.ResourceBundle bundle = Contexts.isApplicationContextActive() ? ResourceBundle.instance() : null;
        Locale locale = bundle == null ? new Locale("DUMMY") : bundle.getLocale();
        ClassValidator validator = this.validators.get(locale);
        if (validator == null) {
            validator = bundle == null ? new ClassValidator(this.beanClass) : new ClassValidator(this.beanClass, bundle);
            this.validators.put(locale, validator);
        }
        return validator;
    }

    public static Model forClass(Class clazz) {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        String name = Model.getModelName(clazz);
        Model model = (Model)Contexts.getApplicationContext().get(name);
        if (model == null) {
            model = clazz.isAnnotationPresent(javax.persistence.Entity.class) ? new Entity(clazz) : new Model(clazz);
            Contexts.getApplicationContext().set(name, (Object)model);
        }
        return model;
    }

    static String getModelName(Class clazz) {
        return clazz.getName() + ".model";
    }
}

