/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.contexts;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Events;

public class WebApplicationContext
implements Context {
    private ServletContext servletContext;

    public ScopeType getType() {
        return ScopeType.APPLICATION;
    }

    private String getKey(String name) {
        return name;
    }

    public WebApplicationContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Object get(String name) {
        return this.servletContext.getAttribute(this.getKey(name));
    }

    public void set(String name, Object value) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preSetVariable." + name, new Object[0]);
        }
        this.servletContext.setAttribute(this.getKey(name), value);
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postSetVariable." + name, new Object[0]);
        }
    }

    public boolean isSet(String name) {
        return this.get(name) != null;
    }

    public void remove(String name) {
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.preRemoveVariable." + name, new Object[0]);
        }
        this.servletContext.removeAttribute(this.getKey(name));
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.postRemoveVariable." + name, new Object[0]);
        }
    }

    public String[] getNames() {
        Enumeration names = this.servletContext.getAttributeNames();
        ArrayList<String> results = new ArrayList<String>();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (this.servletContext.getAttribute(name) == null) continue;
            results.add(name);
        }
        return results.toArray(new String[0]);
    }

    public Object get(Class clazz) {
        return this.get(Component.getComponentName(clazz));
    }

    public void flush() {
    }
}

