/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;

public class LockOptions
implements Serializable {
    public static final LockOptions NONE = new LockOptions(LockMode.NONE);
    public static final LockOptions READ = new LockOptions(LockMode.READ);
    public static final LockOptions UPGRADE = new LockOptions(LockMode.UPGRADE);
    private LockMode lockMode = LockMode.NONE;
    private Map aliasSpecificLockModes = new HashMap();
    public static final int NO_WAIT = 0;
    public static final int WAIT_FOREVER = -1;
    private int timeout = -1;
    private boolean scope = false;

    public LockOptions() {
    }

    public LockOptions(LockMode lockMode) {
        this.lockMode = lockMode;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public LockOptions setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public LockOptions setAliasSpecificLockMode(String alias, LockMode lockMode) {
        this.aliasSpecificLockModes.put(alias, lockMode);
        return this;
    }

    public LockMode getAliasSpecificLockMode(String alias) {
        return (LockMode)((Object)this.aliasSpecificLockModes.get(alias));
    }

    public LockMode getEffectiveLockMode(String alias) {
        LockMode lockMode = this.getAliasSpecificLockMode(alias);
        if (lockMode == null) {
            lockMode = this.lockMode;
        }
        return lockMode == null ? LockMode.NONE : lockMode;
    }

    public int getAliasLockCount() {
        return this.aliasSpecificLockModes.size();
    }

    public Iterator getAliasLockIterator() {
        return this.aliasSpecificLockModes.entrySet().iterator();
    }

    public int getTimeOut() {
        return this.timeout;
    }

    public LockOptions setTimeOut(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean getScope() {
        return this.scope;
    }

    public LockOptions setScope(boolean scope) {
        this.scope = scope;
        return this;
    }

    public static LockOptions copy(LockOptions from, LockOptions dest) {
        dest.setLockMode(from.getLockMode());
        dest.setScope(from.getScope());
        dest.setTimeOut(from.getTimeOut());
        dest.aliasSpecificLockModes = new HashMap(from.aliasSpecificLockModes);
        return dest;
    }
}

