/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.buddyreplication;

import java.util.ArrayList;
import java.util.List;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.commands.AbstractVisitor;
import org.jboss.cache.commands.CommandsFactory;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.legacy.write.CreateNodeCommand;
import org.jboss.cache.commands.read.ExistsCommand;
import org.jboss.cache.commands.read.GetChildrenNamesCommand;
import org.jboss.cache.commands.read.GetDataMapCommand;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.read.GetKeysCommand;
import org.jboss.cache.commands.read.GetNodeCommand;
import org.jboss.cache.commands.read.GravitateDataCommand;
import org.jboss.cache.commands.tx.CommitCommand;
import org.jboss.cache.commands.tx.OptimisticPrepareCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.commands.tx.RollbackCommand;
import org.jboss.cache.commands.write.ClearDataCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.InvalidateCommand;
import org.jboss.cache.commands.write.MoveCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.commands.write.RemoveKeyCommand;
import org.jboss.cache.commands.write.RemoveNodeCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Fqn2BuddyFqnVisitor
extends AbstractVisitor {
    private BuddyFqnTransformer buddyFqnTransformer;
    private final String buddyGroupName;
    CommandsFactory factory;

    public Fqn2BuddyFqnVisitor(String buddyGroupName) {
        this.buddyGroupName = buddyGroupName == null ? "null" : buddyGroupName;
    }

    public Fqn2BuddyFqnVisitor(String buddyGroupName, CommandsFactory cf) {
        this.buddyGroupName = buddyGroupName == null ? "null" : buddyGroupName;
        this.factory = cf;
    }

    @Override
    public Object visitCommitCommand(InvocationContext ctx, CommitCommand commitCommand) throws Throwable {
        return commitCommand;
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildPutDataMapCommand(null, transformed, command.getData());
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildPutKeyValueCommand(null, transformed, command.getKey(), command.getValue());
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildPutForExternalReadCommand(null, transformed, command.getKey(), command.getValue());
    }

    @Override
    public Object visitRemoveNodeCommand(InvocationContext ctx, RemoveNodeCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildRemoveNodeCommand(command.getGlobalTransaction(), transformed);
    }

    @Override
    public Object visitClearDataCommand(InvocationContext ctx, ClearDataCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildClearDataCommand(command.getGlobalTransaction(), transformed);
    }

    @Override
    public Object visitEvictFqnCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Fqn fqn = this.getBackupFqn(command.getFqn());
        return this.factory.buildEvictFqnCommand(fqn);
    }

    @Override
    public Object visitInvalidateCommand(InvocationContext ctx, InvalidateCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildInvalidateCommand(transformed);
    }

    @Override
    public Object visitRemoveKeyCommand(InvocationContext ctx, RemoveKeyCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildRemoveKeyCommand(null, transformed, command.getKey());
    }

    @Override
    public Object visitGetDataMapCommand(InvocationContext ctx, GetDataMapCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildGetDataMapCommand(transformed);
    }

    @Override
    public Object visitExistsNodeCommand(InvocationContext ctx, ExistsCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildEvictFqnCommand(transformed);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildGetKeyValueCommand(transformed, command.getKey(), command.isSendNodeEvent());
    }

    @Override
    public Object visitGetNodeCommand(InvocationContext ctx, GetNodeCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildGetNodeCommand(transformed);
    }

    @Override
    public Object visitGetKeysCommand(InvocationContext ctx, GetKeysCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildGetKeysCommand(transformed);
    }

    @Override
    public Object visitGetChildrenNamesCommand(InvocationContext ctx, GetChildrenNamesCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildGetChildrenNamesCommand(transformed);
    }

    @Override
    public Object visitMoveCommand(InvocationContext ctx, MoveCommand command) throws Throwable {
        Fqn transformedFrom = this.getBackupFqn(command.getFqn());
        Fqn transformedTo = this.getBackupFqn(command.getTo());
        return this.factory.buildMoveCommand(transformedFrom, transformedTo);
    }

    @Override
    public Object visitGravitateDataCommand(InvocationContext ctx, GravitateDataCommand command) throws Throwable {
        Fqn transformed = this.getBackupFqn(command.getFqn());
        return this.factory.buildGravitateDataCommand(transformed, command.isSearchSubtrees());
    }

    @Override
    public Object visitPrepareCommand(InvocationContext ctx, PrepareCommand command) throws Throwable {
        List<WriteCommand> toTransform = command.getModifications();
        List<WriteCommand> transformedCommands = this.transformBatch(toTransform);
        return this.factory.buildPrepareCommand(command.getGlobalTransaction(), transformedCommands, command.getLocalAddress(), command.isOnePhaseCommit());
    }

    @Override
    public Object visitRollbackCommand(InvocationContext ctx, RollbackCommand command) throws Throwable {
        return this.factory.buildRollbackCommand(null);
    }

    @Override
    public Object visitOptimisticPrepareCommand(InvocationContext ctx, OptimisticPrepareCommand command) throws Throwable {
        List<WriteCommand> transformed = this.transformBatch(command.getModifications());
        return this.factory.buildOptimisticPrepareCommand(command.getGlobalTransaction(), transformed, command.getLocalAddress(), command.isOnePhaseCommit());
    }

    @Override
    public Object visitCreateNodeCommand(InvocationContext ctx, CreateNodeCommand command) throws Throwable {
        return this.factory.buildCreateNodeCommand(this.getBackupFqn(command.getFqn()));
    }

    public List<WriteCommand> transformBatch(List<WriteCommand> toTransform) throws Throwable {
        ArrayList<WriteCommand> transformedCommands = new ArrayList<WriteCommand>(toTransform.size());
        for (WriteCommand com : toTransform) {
            transformedCommands.add((WriteCommand)com.acceptVisitor(null, this));
        }
        return transformedCommands;
    }

    public Fqn getBackupFqn(Fqn originalFqn) {
        return this.buddyFqnTransformer.getBackupFqn(this.buddyGroupName, originalFqn);
    }

    public void setBuddyFqnTransformer(BuddyFqnTransformer buddyFqnTransformer) {
        this.buddyFqnTransformer = buddyFqnTransformer;
    }
}

