/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.graphicImage;

import java.io.IOException;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.jboss.seam.core.Image;
import org.jboss.seam.ui.JSF;
import org.jboss.seam.ui.graphicImage.ImageTransform;
import org.jboss.seam.ui.graphicImage.UIGraphicImage;

public class UITransformImageSize
extends UIComponentBase
implements ImageTransform {
    private Boolean maintainRatio;
    private String width;
    private String height;
    private String factor;

    public String getFamily() {
        return "org.jboss.seam.ui.UIImageTransform";
    }

    public void applyTransform(Image image, UIGraphicImage cmp) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        if (this.isMaintainRatio()) {
            if (this.getWidth() != null && this.getHeight() != null) {
                throw new UnsupportedOperationException("Cannot maintain ratio and specify height and width");
            }
            if (this.getWidth() != null) {
                image.scaleToWidth(new Integer(this.getWidth()).intValue());
            } else if (this.getHeight() != null) {
                image.scaleToHeight(new Integer(this.getHeight()).intValue());
            }
        } else if (this.getFactor() != null) {
            if (this.getWidth() != null || this.getHeight() != null) {
                throw new UnsupportedOperationException("Cannot scale by a factor and specify height and width");
            }
            image.scale(new Double(this.factor).doubleValue());
        } else {
            image.resize(new Integer(this.getWidth()).intValue(), new Integer(this.getHeight()).intValue());
        }
    }

    public boolean isMaintainRatio() {
        if (this.maintainRatio != null) {
            return this.maintainRatio;
        }
        ValueBinding vb = this.getValueBinding("maintainRatio");
        Boolean b = vb == null ? null : JSF.getBooleanValue(this.getFacesContext(), vb);
        return b == null ? false : b;
    }

    public void setMaintainRatio(boolean maintainRatio) {
        this.maintainRatio = maintainRatio;
    }

    public String getWidth() {
        if (this.width != null) {
            return this.width;
        }
        ValueBinding vb = this.getValueBinding("width");
        return vb == null ? null : JSF.getStringValue(this.getFacesContext(), vb);
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getHeight() {
        if (this.height != null) {
            return this.height;
        }
        ValueBinding vb = this.getValueBinding("height");
        return vb == null ? null : JSF.getStringValue(this.getFacesContext(), vb);
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public String getFactor() {
        if (this.factor != null) {
            return this.factor;
        }
        ValueBinding vb = this.getValueBinding("factor");
        return vb == null ? null : JSF.getStringValue(this.getFacesContext(), vb);
    }

    public void setFactor(String factor) {
        this.factor = factor;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{super.saveState(context), this.factor, this.height, this.width, this.maintainRatio};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] objects = (Object[])state;
        super.restoreState(context, objects[0]);
        this.factor = (String)objects[1];
        this.height = (String)objects[2];
        this.width = (String)objects[3];
        this.maintainRatio = (Boolean)objects[4];
    }
}

