/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.core.HttpError;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Pages;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Navigator {
    private static final LogProvider log = Logging.getLogProvider(Navigator.class);

    protected void error(int code, String message) {
        if (log.isDebugEnabled()) {
            log.debug("sending error: " + code);
        }
        HttpError httpError = HttpError.instance();
        if (message == null) {
            httpError.send(code);
        } else {
            httpError.send(code, message);
        }
    }

    protected void redirect(String viewId, Map<String, Object> parameters) {
        if (Strings.isEmpty(viewId)) {
            viewId = Pages.getCurrentViewId();
        }
        if (log.isDebugEnabled()) {
            log.debug("redirecting to: " + viewId);
        }
        Manager.instance().redirect(viewId, parameters, true);
    }

    protected void render(String viewId) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!Strings.isEmpty(viewId)) {
            UIViewRoot viewRoot = facesContext.getApplication().getViewHandler().createView(facesContext, viewId);
            facesContext.setViewRoot(viewRoot);
        } else {
            viewId = Pages.getViewId(facesContext);
        }
        if (log.isDebugEnabled()) {
            log.debug("rendering: " + viewId);
        }
        facesContext.renderResponse();
    }

    protected static String getDisplayMessage(Exception e, String message) {
        if (Strings.isEmpty(message) && e.getMessage() != null) {
            return e.getMessage();
        }
        return message;
    }

    protected static void addFacesMessage(String message, FacesMessage.Severity severity, Object ... params) {
        if (Contexts.isConversationContextActive() && !Strings.isEmpty(message)) {
            FacesMessages.instance().add(severity, message, params);
        }
    }
}

