/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.dnd;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.dnd.Draggable;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class DraggableRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Draggable draggable = (Draggable)component;
        String draggableVar = this.createUniqueWidgetVar(facesContext, (UIComponent)draggable);
        String parentClientId = draggable.getParent().getClientId(facesContext);
        String clientId = draggable.getClientId(facesContext);
        writer.startElement("script", (UIComponent)draggable);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("PrimeFaces.onContentReady('" + parentClientId + "', function() {\n");
        writer.write(draggableVar + " = new PrimeFaces.widget.Draggable('" + parentClientId + "',");
        writer.write("{");
        writer.write("proxy:" + draggable.isProxy());
        if (draggable.isDragOnly()) {
            writer.write(",dragOnly:true");
        } else {
            UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)draggable);
            String formClientId = null;
            if (form == null) {
                throw new FacesException("Draggable: '" + clientId + "' needs to be enclosed in a form when dropping is enabled");
            }
            formClientId = form.getClientId(facesContext);
            writer.write(",formClientId:'" + formClientId + "'");
            if (draggable.getUpdate() != null) {
                writer.write(",update:'" + draggable.getUpdate() + "'");
            }
        }
        writer.write("});\n");
        writer.write("});\n");
        writer.endElement("script");
    }
}

