/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectOne;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.radio.HtmlRadio;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRadioRendererBase;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlRadioRenderer
extends HtmlRadioRendererBase {
    private static final String LAYOUT_SPREAD = "spread";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (component instanceof HtmlRadio) {
            this.renderRadio(context, (HtmlRadio)component);
        } else if (HtmlRendererUtils.isDisplayValueOnly(component)) {
            HtmlRendererUtils.renderDisplayValueOnlyForSelects(context, component);
        } else if (component instanceof UISelectOne) {
            String layout = this.getLayout(component);
            if (layout != null && layout.equals(LAYOUT_SPREAD)) {
                return;
            }
            super.encodeEnd(context, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    private void renderRadio(FacesContext facesContext, HtmlRadio radio) throws IOException {
        Converter converter;
        String forAttr = radio.getFor();
        if (forAttr == null) {
            throw new IllegalStateException("mandatory attribute 'for'");
        }
        int index = radio.getIndex();
        if (index < 0) {
            throw new IllegalStateException("positive index must be given");
        }
        UIComponent uiComponent = radio.findComponent(forAttr);
        if (uiComponent == null) {
            throw new IllegalStateException("Could not find component '" + forAttr + "' (calling findComponent on component '" + radio.getClientId(facesContext) + "')");
        }
        if (!(uiComponent instanceof UISelectOne)) {
            throw new IllegalStateException("UISelectOne expected");
        }
        UISelectOne uiSelectOne = (UISelectOne)uiComponent;
        List selectItemList = RendererUtils.getSelectItemList(uiSelectOne);
        if (index >= selectItemList.size()) {
            throw new IndexOutOfBoundsException("index " + index + " >= " + selectItemList.size());
        }
        try {
            converter = RendererUtils.findUIOutputConverter(facesContext, (UIOutput)uiSelectOne);
        }
        catch (FacesException e) {
            converter = null;
        }
        Object currentValue = RendererUtils.getObjectValue((UIComponent)uiSelectOne);
        currentValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)uiSelectOne, converter, currentValue);
        SelectItem selectItem = (SelectItem)selectItemList.get(index);
        String itemStrValue = RendererUtils.getConvertedStringValue(facesContext, (UIComponent)uiSelectOne, converter, selectItem.getValue());
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("label", (UIComponent)uiSelectOne);
        this.renderRadio(facesContext, (UIComponent)uiSelectOne, itemStrValue, selectItem.getLabel(), selectItem.isDisabled(), itemStrValue.equals(currentValue), false);
        writer.endElement("label");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return true;
        }
        return super.isDisabled(facesContext, uiComponent);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (!(uiComponent instanceof HtmlRadio)) {
            super.decode(facesContext, uiComponent);
        }
    }
}

