/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.util.ArrayUtils;
import org.apache.myfaces.shared_tomahawk.util.StringUtils;

public class HtmlTableRendererBase
extends HtmlRenderer {
    protected static final String HEADER_FACET_NAME = "header";
    protected static final String FOOTER_FACET_NAME = "footer";
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$shared_tomahawk$renderkit$html$HtmlTableRendererBase == null ? (class$org$apache$myfaces$shared_tomahawk$renderkit$html$HtmlTableRendererBase = HtmlTableRendererBase.class$("org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlTableRendererBase")) : class$org$apache$myfaces$shared_tomahawk$renderkit$html$HtmlTableRendererBase));
    static /* synthetic */ Class class$org$apache$myfaces$shared_tomahawk$renderkit$html$HtmlTableRendererBase;
    static /* synthetic */ Class class$javax$faces$component$UIData;

    protected int getNewspaperColumns(UIComponent component) {
        return 1;
    }

    protected UIComponent getNewspaperTableSpacer(UIComponent component) {
        return null;
    }

    protected boolean hasNewspaperTableSpacer(UIComponent component) {
        return false;
    }

    protected boolean isNewspaperHorizontalOrientation(UIComponent component) {
        return false;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.beforeTable(facesContext, (UIData)uiComponent);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("table", uiComponent);
        HtmlRendererUtils.writeIdIfNecessary(writer, uiComponent, facesContext);
        HtmlRendererUtils.renderHTMLAttributes(writer, uiComponent, HTML.TABLE_PASSTHROUGH_ATTRIBUTES);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        this.beforeBody(facesContext, (UIData)component);
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tbody", component);
        writer.writeAttribute("id", (Object)(component.getClientId(facesContext) + ":tbody_element"), null);
        this.encodeInnerHtml(facesContext, component);
        writer.endElement("tbody");
        this.afterBody(facesContext, (UIData)component);
    }

    protected static Styles getStyles(UIData uiData) {
        String columnClasses;
        String rowClasses;
        if (uiData instanceof HtmlDataTable) {
            rowClasses = ((HtmlDataTable)uiData).getRowClasses();
            columnClasses = ((HtmlDataTable)uiData).getColumnClasses();
        } else {
            rowClasses = (String)uiData.getAttributes().get("rowClasses");
            columnClasses = (String)uiData.getAttributes().get("columnClasses");
        }
        return new Styles(rowClasses, columnClasses);
    }

    public void encodeInnerHtml(FacesContext facesContext, UIComponent component) throws IOException {
        int last;
        UIData uiData = (UIData)component;
        ResponseWriter writer = facesContext.getResponseWriter();
        Styles styles = HtmlTableRendererBase.getStyles(uiData);
        int first = uiData.getFirst();
        int rows = uiData.getRows();
        if (rows <= 0) {
            last = uiData.getRowCount();
        } else {
            last = first + rows;
            if (last > uiData.getRowCount()) {
                last = uiData.getRowCount();
            }
        }
        int newspaperColumns = this.getNewspaperColumns(component);
        int newspaperRows = (last - first) % newspaperColumns == 0 ? (last - first) / newspaperColumns : (last - first) / newspaperColumns + 1;
        boolean newspaperHorizontalOrientation = this.isNewspaperHorizontalOrientation(component);
        for (int nr = 0; nr < newspaperRows; ++nr) {
            for (int nc = 0; nc < newspaperColumns; ++nc) {
                int currentRow = newspaperHorizontalOrientation ? nr * newspaperColumns + nc + first : nc * newspaperRows + nr + first;
                if (currentRow >= last) continue;
                uiData.setRowIndex(currentRow);
                if (!uiData.isRowAvailable()) {
                    log.error((Object)("Row is not available. Rowindex = " + currentRow));
                    break;
                }
                if (nc == 0) {
                    this.beforeRow(facesContext, uiData);
                    HtmlRendererUtils.writePrettyLineSeparator(facesContext);
                    this.renderRowStart(facesContext, writer, uiData, styles, nr);
                }
                List children = this.getChildren(component);
                int size = this.getChildCount(component);
                for (int j = 0; j < size; ++j) {
                    UIComponent child = (UIComponent)children.get(j);
                    if (!child.isRendered()) continue;
                    boolean columnRendering = child instanceof UIColumn;
                    if (columnRendering) {
                        this.beforeColumn(facesContext, uiData, j);
                    }
                    this.encodeColumnChild(facesContext, writer, uiData, child, styles, nc * uiData.getChildCount() + j);
                    if (!columnRendering) continue;
                    this.afterColumn(facesContext, uiData, j);
                }
                if (!this.hasNewspaperTableSpacer((UIComponent)uiData) || nc >= newspaperColumns - 1) continue;
                this.renderSpacerCell(facesContext, writer, (UIComponent)uiData);
            }
            this.renderRowEnd(facesContext, writer, uiData);
            this.afterRow(facesContext, uiData);
        }
    }

    protected void encodeColumnChild(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, Styles styles, int columnStyleIndex) throws IOException {
        if (component instanceof UIColumn) {
            this.renderColumnBody(facesContext, writer, uiData, component, styles, columnStyleIndex);
        }
    }

    protected void renderColumnBody(FacesContext facesContext, ResponseWriter writer, UIData uiData, UIComponent component, Styles styles, int columnStyleIndex) throws IOException {
        writer.startElement("td", (UIComponent)uiData);
        if (styles.hasColumnStyle()) {
            writer.writeAttribute("class", (Object)styles.getColumnStyle(columnStyleIndex), null);
        }
        RendererUtils.renderChild(facesContext, component);
        writer.endElement("td");
    }

    protected void renderRowStart(FacesContext facesContext, ResponseWriter writer, UIData uiData, Styles styles, int rowStyleIndex) throws IOException {
        writer.startElement("tr", (UIComponent)uiData);
        this.renderRowStyle(facesContext, writer, uiData, styles, rowStyleIndex);
        Object rowId = uiData.getAttributes().get("org.apache.myfaces.dataTable.ROW_ID");
        if (rowId != null) {
            writer.writeAttribute("id", (Object)rowId.toString(), null);
        }
    }

    protected void renderRowStyle(FacesContext facesContext, ResponseWriter writer, UIData uiData, Styles styles, int rowStyleIndex) throws IOException {
        if (styles.hasRowStyle()) {
            String rowStyle = styles.getRowStyle(rowStyleIndex);
            writer.writeAttribute("class", (Object)rowStyle, null);
        }
    }

    protected void renderRowEnd(FacesContext facesContext, ResponseWriter writer, UIData uiData) throws IOException {
        writer.endElement("tr");
    }

    protected void beforeTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void beforeBody(FacesContext facesContext, UIData uiData) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        this.renderFacet(facesContext, writer, (UIComponent)uiData, true);
        this.renderFacet(facesContext, writer, (UIComponent)uiData, false);
    }

    protected void beforeRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterRow(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void beforeColumn(FacesContext facesContext, UIData uiData, int columnIndex) throws IOException {
    }

    protected void afterColumn(FacesContext facesContext, UIData uiData, int columnIndex) throws IOException {
    }

    protected void beforeColumnHeaderOrFooter(FacesContext facesContext, UIData uiData, boolean header, int columnIndex) throws IOException {
    }

    protected void afterColumnHeaderOrFooter(FacesContext facesContext, UIData uiData, boolean header, int columnIndex) throws IOException {
    }

    protected void afterBody(FacesContext facesContext, UIData uiData) throws IOException {
    }

    protected void afterTable(FacesContext facesContext, UIData uiData) throws IOException {
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = HtmlTableRendererBase.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData);
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("table");
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        this.afterTable(facesContext, (UIData)uiComponent);
    }

    protected void renderFacet(FacesContext facesContext, ResponseWriter writer, UIComponent component, boolean header) throws IOException {
        UIComponent facet;
        int colspan = 0;
        boolean hasColumnFacet = false;
        Iterator it = this.getChildren(component).iterator();
        while (it.hasNext()) {
            UIComponent uiComponent = (UIComponent)it.next();
            if (!uiComponent.isRendered()) continue;
            colspan += this.determineChildColSpan(uiComponent);
            if (hasColumnFacet) continue;
            hasColumnFacet = this.hasFacet(header, uiComponent);
        }
        UIComponent uIComponent = facet = header ? (UIComponent)component.getFacets().get(HEADER_FACET_NAME) : (UIComponent)component.getFacets().get(FOOTER_FACET_NAME);
        if (facet != null || hasColumnFacet) {
            String elemName = header ? "thead" : "tfoot";
            HtmlRendererUtils.writePrettyLineSeparator(facesContext);
            writer.startElement(elemName, component);
            if (header) {
                String headerStyleClass = HtmlTableRendererBase.getHeaderClass(component);
                if (facet != null) {
                    this.renderTableHeaderRow(facesContext, writer, component, facet, headerStyleClass, colspan);
                }
                if (hasColumnFacet) {
                    this.renderColumnHeaderRow(facesContext, writer, component, headerStyleClass);
                }
            } else {
                String footerStyleClass = HtmlTableRendererBase.getFooterClass(component);
                if (hasColumnFacet) {
                    this.renderColumnFooterRow(facesContext, writer, component, footerStyleClass);
                }
                if (facet != null) {
                    this.renderTableFooterRow(facesContext, writer, component, facet, footerStyleClass, colspan);
                }
            }
            writer.endElement(elemName);
        }
    }

    protected boolean hasFacet(boolean header, UIComponent uiComponent) {
        if (uiComponent instanceof UIColumn) {
            UIColumn uiColumn = (UIColumn)uiComponent;
            return header ? uiColumn.getHeader() != null : uiColumn.getFooter() != null;
        }
        return false;
    }

    protected int determineChildColSpan(UIComponent uiComponent) {
        if (uiComponent instanceof UIColumn) {
            return 1;
        }
        return 0;
    }

    protected void renderTableHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent headerFacet, String headerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, component, headerFacet, headerStyleClass, "th", colspan);
    }

    protected void renderTableFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent footerFacet, String footerStyleClass, int colspan) throws IOException {
        this.renderTableHeaderOrFooterRow(facesContext, writer, component, footerFacet, footerStyleClass, "td", colspan);
    }

    protected void renderColumnHeaderRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String headerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, headerStyleClass, true);
    }

    protected void renderColumnFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String footerStyleClass) throws IOException {
        this.renderColumnHeaderOrFooterRow(facesContext, writer, component, footerStyleClass, false);
    }

    private void renderTableHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, UIComponent facet, String styleClass, String colElementName, int colspan) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", component);
        writer.startElement(colElementName, component);
        if (colElementName.equals("th")) {
            writer.writeAttribute("scope", (Object)"colgroup", null);
        }
        int newsPaperColumns = this.getNewspaperColumns(component);
        int totalColumns = colspan * newsPaperColumns;
        if (this.hasNewspaperTableSpacer(component)) {
            totalColumns = totalColumns + newsPaperColumns - 1;
        }
        writer.writeAttribute("colspan", (Object)new Integer(totalColumns), null);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement(colElementName);
        writer.endElement("tr");
    }

    private void renderColumnHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent component, String styleClass, boolean header) throws IOException {
        HtmlRendererUtils.writePrettyLineSeparator(facesContext);
        writer.startElement("tr", component);
        int columnIndex = 0;
        int newspaperColumns = this.getNewspaperColumns(component);
        for (int nc = 0; nc < newspaperColumns; ++nc) {
            Iterator it = this.getChildren(component).iterator();
            while (it.hasNext()) {
                UIComponent uiComponent = (UIComponent)it.next();
                if (uiComponent.isRendered()) {
                    if (component instanceof UIData && uiComponent instanceof UIColumn) {
                        this.beforeColumnHeaderOrFooter(facesContext, (UIData)component, header, columnIndex);
                    }
                    this.renderColumnChildHeaderOrFooterRow(facesContext, writer, uiComponent, styleClass, header);
                    if (component instanceof UIData && uiComponent instanceof UIColumn) {
                        this.afterColumnHeaderOrFooter(facesContext, (UIData)component, header, columnIndex);
                    }
                }
                ++columnIndex;
            }
            if (!this.hasNewspaperTableSpacer(component) || nc >= newspaperColumns - 1) continue;
            this.renderSpacerCell(facesContext, writer, component);
        }
        writer.endElement("tr");
    }

    protected void renderSpacerCell(FacesContext facesContext, ResponseWriter writer, UIComponent component) throws IOException {
        UIComponent spacer = this.getNewspaperTableSpacer(component);
        if (spacer == null) {
            return;
        }
        writer.startElement("td", component);
        RendererUtils.renderChild(facesContext, spacer);
        writer.endElement("td");
    }

    protected void renderColumnChildHeaderOrFooterRow(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, String styleClass, boolean header) throws IOException {
        if (uiComponent instanceof UIColumn) {
            if (header) {
                this.renderColumnHeaderCell(facesContext, writer, uiComponent, ((UIColumn)uiComponent).getHeader(), styleClass, 0);
            } else {
                this.renderColumnFooterCell(facesContext, writer, uiComponent, ((UIColumn)uiComponent).getFooter(), styleClass, 0);
            }
        }
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String headerStyleClass, int colspan) throws IOException {
        this.renderColumnHeaderCell(facesContext, writer, (UIComponent)uiColumn, uiColumn.getHeader(), headerStyleClass, colspan);
    }

    protected void renderColumnHeaderCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String headerStyleClass, int colspan) throws IOException {
        writer.startElement("th", uiComponent);
        if (colspan > 1) {
            writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
        }
        if (headerStyleClass != null) {
            writer.writeAttribute("class", (Object)headerStyleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("th");
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIColumn uiColumn, String footerStyleClass, int colspan) throws IOException {
        this.renderColumnFooterCell(facesContext, writer, (UIComponent)uiColumn, uiColumn.getFooter(), footerStyleClass, colspan);
    }

    protected void renderColumnFooterCell(FacesContext facesContext, ResponseWriter writer, UIComponent uiComponent, UIComponent facet, String footerStyleClass, int colspan) throws IOException {
        writer.startElement("td", uiComponent);
        if (colspan > 1) {
            writer.writeAttribute("colspan", (Object)new Integer(colspan), null);
        }
        if (footerStyleClass != null) {
            writer.writeAttribute("class", (Object)footerStyleClass, null);
        }
        if (facet != null) {
            RendererUtils.renderChild(facesContext, facet);
        }
        writer.endElement("td");
    }

    protected static String getHeaderClass(UIComponent component) {
        if (component instanceof HtmlDataTable) {
            return ((HtmlDataTable)component).getHeaderClass();
        }
        return (String)component.getAttributes().get("headerClass");
    }

    protected static String getFooterClass(UIComponent component) {
        if (component instanceof HtmlDataTable) {
            return ((HtmlDataTable)component).getFooterClass();
        }
        return (String)component.getAttributes().get("footerClass");
    }

    public void decode(FacesContext context, UIComponent component) {
        super.decode(context, component);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class Styles {
        private String[] _columnStyle;
        private String[] _rowStyle;

        Styles(String rowStyles, String columnStyles) {
            this._rowStyle = rowStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(rowStyles, ','));
            this._columnStyle = columnStyles == null ? ArrayUtils.EMPTY_STRING_ARRAY : StringUtils.trim(StringUtils.splitShortString(columnStyles, ','));
        }

        public String getRowStyle(int idx) {
            if (!this.hasRowStyle()) {
                return null;
            }
            return this._rowStyle[idx % this._rowStyle.length];
        }

        public String getColumnStyle(int idx) {
            if (!this.hasColumnStyle()) {
                return null;
            }
            return this._columnStyle[idx % this._columnStyle.length];
        }

        public boolean hasRowStyle() {
            return this._rowStyle.length > 0;
        }

        public boolean hasColumnStyle() {
            return this._columnStyle.length > 0;
        }
    }
}

