/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.protocol.spec200502;

import javax.xml.datatype.Duration;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMAbstractSerializable;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spec200502.RMProviderImpl;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMCreateSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMIncompleteSequenceBehavior;

final class RMCreateSequenceImpl
extends RMAbstractSerializable
implements RMCreateSequence {
    private static final RMProvider PROVIDER = RMProviderImpl.getInstance();
    private String acksTo;
    private Duration expires;
    private RMCreateSequence.RMOffer offer;

    RMCreateSequenceImpl() {
    }

    public String getAcksTo() {
        return this.acksTo;
    }

    public Duration getExpires() {
        return this.expires;
    }

    public RMCreateSequence.RMOffer getOffer() {
        return this.offer;
    }

    public RMCreateSequence.RMOffer newOffer() {
        return new OfferImpl();
    }

    public void setAcksTo(String address) {
        if (address == null || address.trim().equals("")) {
            throw new IllegalArgumentException("Address cannot be null nor empty string");
        }
        if (this.acksTo != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.acksTo = address;
    }

    public void setExpires(Duration duration) {
        if (duration == null || duration.toString().equals("")) {
            throw new IllegalArgumentException("Duration cannot be null nor empty string");
        }
        if (this.expires != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.expires = duration;
    }

    public void setOffer(RMCreateSequence.RMOffer offer) {
        if (offer == null) {
            throw new IllegalArgumentException("Offer cannot be null");
        }
        if (!(offer instanceof OfferImpl)) {
            throw new IllegalArgumentException();
        }
        if (offer.getIdentifier() == null) {
            throw new IllegalArgumentException("Offer identifier must be specified");
        }
        if (offer.getEndpoint() == null) {
            throw new IllegalArgumentException("Offer endpoint address must be specified");
        }
        if (this.offer != null) {
            throw new UnsupportedOperationException("Value already set, cannot be overriden");
        }
        this.offer = offer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acksTo == null ? 0 : this.acksTo.hashCode());
        result = 31 * result + (this.expires == null ? 0 : this.expires.hashCode());
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RMCreateSequenceImpl)) {
            return false;
        }
        RMCreateSequenceImpl other = (RMCreateSequenceImpl)obj;
        if (this.acksTo == null ? other.acksTo != null : !this.acksTo.equals(other.acksTo)) {
            return false;
        }
        if (this.expires == null ? other.expires != null : !this.expires.equals(other.expires)) {
            return false;
        }
        return !(this.offer == null ? other.offer != null : !this.offer.equals(other.offer));
    }

    public RMProvider getProvider() {
        return PROVIDER;
    }

    public void validate() {
        if (this.acksTo == null) {
            throw new RMException("AcksTo must be set");
        }
    }

    private static class OfferImpl
    implements RMCreateSequence.RMOffer {
        private String duration;
        private String identifier;

        private OfferImpl() {
        }

        public String getEndpoint() {
            return null;
        }

        public String getExpires() {
            return this.duration;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public RMIncompleteSequenceBehavior getIncompleteSequenceBehavior() {
            return null;
        }

        public void setEndpoint(String address) {
        }

        public void setExpires(String duration) {
            if (duration == null || duration.trim().equals("")) {
                throw new IllegalArgumentException("Duration cannot be null nor empty string");
            }
            if (this.duration != null) {
                throw new UnsupportedOperationException("Value already set, cannot be overriden");
            }
            this.duration = duration;
        }

        public void setIdentifier(String identifier) {
            if (identifier == null || identifier.trim().equals("")) {
                throw new IllegalArgumentException("Identifier cannot be null nor empty string");
            }
            if (this.identifier != null) {
                throw new UnsupportedOperationException("Value already set, cannot be overriden");
            }
            this.identifier = identifier;
        }

        public void setIncompleteSequenceBehavior(RMIncompleteSequenceBehavior incompleteSequenceBehavior) {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.duration == null ? 0 : this.duration.hashCode());
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OfferImpl)) {
                return false;
            }
            OfferImpl other = (OfferImpl)obj;
            if (this.duration == null ? other.duration != null : !this.duration.equals(other.duration)) {
                return false;
            }
            return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
        }
    }
}

