"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const flags_1 = require("@oclif/parser/lib/flags");
const Listr = require("listr");
const common_flags_1 = require("../../common-flags");
const che_1 = require("../../tasks/che");
const api_1 = require("../../tasks/platforms/api");
class Debug extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Debug);
            const ctx = {};
            const cheTasks = new che_1.CheTasks(flags);
            const apiTasks = new api_1.ApiTasks();
            const tasks = new Listr([], { renderer: flags['listr-renderer'] });
            tasks.add(apiTasks.testApiTasks(flags, this));
            tasks.add(cheTasks.verifyCheNamespaceExistsTask(flags, this));
            tasks.add(cheTasks.debugTask(flags));
            try {
                yield tasks.run(ctx);
                this.log(`CodeReady Workspaces server debug is available on localhost:${flags['debug-port']}.`);
                this.log('The program keeps running to enable port forwarding.');
            }
            catch (error) {
                this.error(error);
            }
        });
    }
}
exports.default = Debug;
Debug.description = 'Enable local debug of CodeReady Workspaces server';
Debug.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    'listr-renderer': common_flags_1.listrRenderer,
    'debug-port': flags_1.integer({
        description: 'CodeReady Workspaces server debug port',
        default: 8000
    })
};
//# sourceMappingURL=debug.js.map