"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const notifier = require("node-notifier");
const che_1 = require("../../api/che");
const kube_1 = require("../../api/kube");
const version_1 = require("../../api/version");
const common_flags_1 = require("../../common-flags");
class List extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(List);
            const kube = new kube_1.KubeHelper(flags);
            const che = new che_1.CheHelper(flags);
            let openshiftOauth = 'No';
            const cr = yield kube.getCheCluster(flags.chenamespace);
            if (cr && cr.spec && cr.spec.auth && cr.spec.auth.openShiftoAuth) {
                openshiftOauth = 'Yes';
            }
            const cheVersion = yield version_1.VersionHelper.getCheVersion(flags);
            cli_ux_1.cli.log(`CodeReady Workspaces Version    : ${cheVersion}`);
            cli_ux_1.cli.log(`CodeReady Workspaces Url        : ${yield che.cheURL(flags.chenamespace)}`);
            cli_ux_1.cli.log(`OpenShift OAuth enabled: ${openshiftOauth}\n`);
            notifier.notify({
                title: 'crwctl',
                message: 'Command server:status has completed successfully.'
            });
        });
    }
}
exports.default = List;
// Implementation-Version it is a property from Manifest.ml inside of che server pod which indicate CodeReady Workspaces build version.
List.description = 'status CodeReady Workspaces server';
List.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
};
//# sourceMappingURL=status.js.map