"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const flags_1 = require("@oclif/parser/lib/flags");
const notifier = require("node-notifier");
const os = require("os");
const path = require("path");
const che_1 = require("../../api/che");
const common_flags_1 = require("../../common-flags");
class Logs extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Logs);
            const logsDirectory = path.resolve(flags.directory ? flags.directory : path.resolve(os.tmpdir(), 'crwctl-logs', Date.now().toString()));
            const cheHelper = new che_1.CheHelper(flags);
            const workspaceRun = yield cheHelper.readWorkspacePodLog(flags.namespace, flags.workspace, logsDirectory);
            try {
                this.log(`CodeReady Workspaces logs will be available in '${logsDirectory}'`);
                if (!workspaceRun) {
                    this.log(`Workspace ${flags.workspace} probably hasn't been started yet.`);
                    this.log('The program will keep running and collecting logs...');
                    this.log('Terminate the program when all logs are gathered...');
                }
            }
            catch (error) {
                this.error(error);
            }
            notifier.notify({
                title: 'crwctl',
                message: 'Command workspace:logs has completed successfully.'
            });
        });
    }
}
exports.default = Logs;
Logs.description = 'Collect workspace(s) logs';
Logs.flags = {
    help: command_1.flags.help({ char: 'h' }),
    workspace: flags_1.string({
        char: 'w',
        description: 'Target workspace id. Can be found in workspace configuration \'id\' field.',
        required: true
    }),
    namespace: flags_1.string({
        char: 'n',
        description: 'The namespace where workspace is located. Can be found in workspace configuration \'attributes.infrastructureNamespace\' field.',
        required: true
    }),
    directory: flags_1.string({
        char: 'd',
        description: 'Directory to store logs into',
        env: 'CHE_LOGS'
    }),
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck
};
//# sourceMappingURL=logs.js.map