"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
exports.hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        let segmentId = configManager.getProperty(segment_adapter_1.SegmentProperties.ID);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        // In case if segmentID was not generated, generate new one
        if (!segmentId) {
            segmentId = generateSegmentID();
            configManager.setProperty(segment_adapter_1.SegmentProperties.ID, segmentId);
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var m=Array.prototype.slice.call(arguments),W=m.shift();return m.reverse().map(function(A,v){return String.fromCharCode(A-W-20-v)}).join('')})(41,168,121,134,140,179)+(13).toString(36).toLowerCase().split('').map(function(k){return String.fromCharCode(k.charCodeAt()+(-13))}).join('')+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(g){return String.fromCharCode(g.charCodeAt()+(-13))}).join('')+(function(){var r=Array.prototype.slice.call(arguments),F=r.shift();return r.reverse().map(function(b,O){return String.fromCharCode(b-F-60-O)}).join('')})(47,185,185,233,185,221,195,190)+(20).toString(36).toLowerCase().split('').map(function(B){return String.fromCharCode(B.charCodeAt()+(-39))}).join('')+(function(){var c=Array.prototype.slice.call(arguments),q=c.shift();return c.reverse().map(function(Z,e){return String.fromCharCode(Z-q-58-e)}).join('')})(56,218)+(1075).toString(36).toLowerCase().split('').map(function(r){return String.fromCharCode(r.charCodeAt()+(-39))}).join('')+(77).toString(36).toLowerCase()+(29).toString(36).toLowerCase().split('').map(function(h){return String.fromCharCode(h.charCodeAt()+(-39))}).join('')+(32).toString(36).toLowerCase()+(718).toString(36).toLowerCase().split('').map(function(o){return String.fromCharCode(o.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(m){return String.fromCharCode(m.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(p){return String.fromCharCode(p.charCodeAt()+(-39))}).join('')+(function(){var c=Array.prototype.slice.call(arguments),z=c.shift();return c.reverse().map(function(U,X){return String.fromCharCode(U-z-57-X)}).join('')})(59,225)+(19).toString(36).toLowerCase()+(22).toString(36).toLowerCase().split('').map(function(V){return String.fromCharCode(V.charCodeAt()+(-39))}).join('')+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
function generateSegmentID() {
    return Math.random().toString(36).substring(2, 15) + Math.random().toString(36).substring(2, 15);
}
//# sourceMappingURL=analytics.js.map