"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChectlContext = void 0;
const tslib_1 = require("tslib");
const os = require("os");
const path = require("path");
const common_flags_1 = require("../common-flags");
const util_1 = require("../util");
const kube_1 = require("./kube");
/**
 * crwctl command context.
 * Can be requested from any location with `ChectlContext#get`
 */
var ChectlContext;
(function (ChectlContext) {
    ChectlContext.IS_OPENSHIFT = 'isOpenShift';
    ChectlContext.IS_OPENSHIFT4 = 'isOpenShift4';
    ChectlContext.START_TIME = 'startTime';
    ChectlContext.END_TIME = 'endTime';
    ChectlContext.CONFIG_DIR = 'configDir';
    ChectlContext.ERROR_LOG = 'errorLog';
    ChectlContext.COMMAND_ID = 'commandId';
    // command specific attributes
    ChectlContext.CUSTOM_CR = 'customCR';
    ChectlContext.CR_PATCH = 'crPatch';
    ChectlContext.LOGS_DIRECTORY = 'directory';
    const ctx = {};
    function init(flags, command) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const kube = new kube_1.KubeHelper(flags);
            ctx[ChectlContext.IS_OPENSHIFT] = yield kube.isOpenShift();
            ctx[ChectlContext.IS_OPENSHIFT4] = yield kube.isOpenShift4();
            if (flags['listr-renderer']) {
                ctx.listrOptions = { renderer: flags['listr-renderer'], collapse: false };
            }
            ctx.highlightedMessages = [];
            ctx[ChectlContext.START_TIME] = Date.now();
            ctx[ChectlContext.CONFIG_DIR] = command.config.configDir;
            ctx[ChectlContext.ERROR_LOG] = command.config.errlog;
            ctx[ChectlContext.COMMAND_ID] = command.id;
            ctx[ChectlContext.LOGS_DIRECTORY] = path.resolve(flags[common_flags_1.LOG_DIRECTORY_KEY] ? flags[common_flags_1.LOG_DIRECTORY_KEY] : path.resolve(os.tmpdir(), 'crwctl-logs', Date.now().toString()));
            ctx[ChectlContext.CUSTOM_CR] = util_1.readCRFile(flags, common_flags_1.CHE_OPERATOR_CR_YAML_KEY);
            ctx[ChectlContext.CR_PATCH] = util_1.readCRFile(flags, common_flags_1.CHE_OPERATOR_CR_PATCH_YAML_KEY);
        });
    }
    ChectlContext.init = init;
    function initAndGet(flags, command) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield init(flags, command);
            return ctx;
        });
    }
    ChectlContext.initAndGet = initAndGet;
    function get() {
        return ctx;
    }
    ChectlContext.get = get;
})(ChectlContext = exports.ChectlContext || (exports.ChectlContext = {}));
//# sourceMappingURL=context.js.map