/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
export declare const KUBERNETES_CLI = "kubectl";
export declare const OPENSHIFT_CLI = "oc";
export declare function getClusterClientCommand(): string;
export declare function isKubernetesPlatformFamily(platform: string): boolean;
export declare function isOpenshiftPlatformFamily(platform: string): boolean;
export declare function generatePassword(passwodLength: number, charactersSet?: string): string;
export declare function base64Decode(arg: string): string;
/**
 * Indicates if stable version of `crwctl` is used.
 */
export declare function isStableVersion(flags: any): boolean;
/**
 * Returns the tag of the image.
 */
export declare function getImageTag(image: string): string | undefined;
export declare function sleep(ms: number): Promise<void>;
/**
 * Returns CR file content. Throws an error, if file doesn't exist.
 * @param flags - parent command flags
 * @param CRKey - key for CR file flag
 * @param command - parent command
 */
export declare function readCRFile(flags: any, CRKey: string): any;
/**
 * Returns command success message with execution time.
 */
export declare function getCommandSuccessMessage(): string;
export declare function notifyCommandCompletedSuccessfully(): void;
/**
 * Determine if a directory is empty.
 */
export declare function isDirEmpty(dirname: string): boolean;
/**
 * Returns command success message with execution time.
 */
export declare function getCommandErrorMessage(err: Error): string;
/**
 * Returns current crwctl version defined in package.json.
 */
export declare function getProjectVersion(): string;
/**
 * Returns current crwctl version defined in package.json.
 */
export declare function getProjectName(): string;
export declare function readPackageJson(): any;
/**
 * Returns latest crwctl version for the given channel.
 */
export declare function getLatestChectlVersion(channel: string): Promise<string | undefined>;
/**
 * The default CodeReady Workspaces namespace has been changed from 'che' to 'eclipse-che'.
 * It checks if legacy namespace 'che' exists. If so all crwctl commands
 * will launched against that namespace otherwise default 'eclipse-che' namespace will be used.
 */
export declare function findWorkingNamespace(flags: any): Promise<string>;
