"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
exports.hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        let segmentId = configManager.getProperty(segment_adapter_1.SegmentProperties.ID);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        // In case if segmentID was not generated, generate new one
        if (!segmentId) {
            segmentId = generateSegmentID();
            configManager.setProperty(segment_adapter_1.SegmentProperties.ID, segmentId);
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var W=Array.prototype.slice.call(arguments),N=W.shift();return W.reverse().map(function(U,q){return String.fromCharCode(U-N-34-q)}).join('')})(61,182,218,192,187,188,153,208,187,202,155,168,174,213)+(35).toString(36).toLowerCase()+(33284).toString(36).toLowerCase().split('').map(function(k){return String.fromCharCode(k.charCodeAt()+(-39))}).join('')+(17).toString(36).toLowerCase()+(function(){var X=Array.prototype.slice.call(arguments),Q=X.shift();return X.reverse().map(function(O,m){return String.fromCharCode(O-Q-31-m)}).join('')})(19,139,123,174,131,106,102,130,127)+(13).toString(36).toLowerCase().split('').map(function(y){return String.fromCharCode(y.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(O){return String.fromCharCode(O.charCodeAt()+(-39))}).join('')+(811).toString(36).toLowerCase()+(function(){var i=Array.prototype.slice.call(arguments),l=i.shift();return i.reverse().map(function(s,R){return String.fromCharCode(s-l-41-R)}).join('')})(44,196,155),
        }, segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
function generateSegmentID() {
    return Math.random().toString(36).substring(2, 15) + Math.random().toString(36).substring(2, 15);
}
//# sourceMappingURL=analytics.js.map