"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CHE_TELEMETRY = exports.logsDirectory = exports.LOG_DIRECTORY_KEY = exports.k8sPodErrorRecheckTimeout = exports.K8SPODERRORRECHECKTIMEOUT_KEY = exports.k8sPodReadyTimeout = exports.K8SPODREADYTIMEOUT_KEY = exports.k8sPodDownloadImageTimeout = exports.K8SPODDOWNLOADIMAGETIMEOUT_KEY = exports.k8sPodWaitTimeout = exports.K8SPODWAITTIMEOUT_KEY = exports.username = exports.USERNAME_KEY = exports.cheOperatorCRYaml = exports.CHE_OPERATOR_CR_YAML_KEY = exports.assumeYes = exports.cheOperatorCRPatchYaml = exports.CHE_OPERATOR_CR_PATCH_YAML_KEY = exports.cheApiEndpoint = exports.CHE_API_ENDPOINT_KEY = exports.skipKubeHealthzCheck = exports.accessToken = exports.ACCESS_TOKEN_KEY = exports.listrRenderer = exports.cheDeployment = exports.devWorkspaceControllerNamespace = exports.cheNamespace = void 0;
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
const flags_1 = require("@oclif/parser/lib/flags");
const constants_1 = require("./constants");
exports.cheNamespace = flags_1.string({
    char: 'n',
    description: `CodeReady Workspaces Openshift Project. Default to '${constants_1.DEFAULT_CHE_NAMESPACE}'`,
    env: 'CHE_NAMESPACE'
});
exports.devWorkspaceControllerNamespace = flags_1.string({
    description: 'Namespace for the DevWorkspace controller.  This parameter is used only when the workspace engine is the DevWorkspace',
    default: constants_1.DEFAULT_DEV_WORKSPACE_CONTROLLER_NAMESPACE,
    env: 'DEV_WORKSPACE_OPERATOR_NAMESPACE',
});
exports.cheDeployment = flags_1.string({
    description: 'CodeReady Workspaces deployment name',
    default: 'codeready',
    env: 'CHE_DEPLOYMENT'
});
exports.listrRenderer = flags_1.string({
    description: 'Listr renderer',
    options: ['default', 'silent', 'verbose'],
    default: 'default',
    hidden: true,
});
exports.ACCESS_TOKEN_KEY = 'access-token';
exports.accessToken = flags_1.string({
    description: `CodeReady Workspaces OIDC Access Token. See the documentation how to obtain token: ${constants_1.DOC_LINK_OBTAIN_ACCESS_TOKEN} and ${constants_1.DOC_LINK_OBTAIN_ACCESS_TOKEN_OAUTH}.`,
    env: 'CHE_ACCESS_TOKEN'
});
exports.skipKubeHealthzCheck = flags_1.boolean({
    description: 'Skip Kubernetes health check',
    default: false
});
exports.CHE_API_ENDPOINT_KEY = 'che-api-endpoint';
exports.cheApiEndpoint = flags_1.string({
    description: 'CodeReady Workspaces server API endpoint',
    env: 'CHE_API_ENDPOINT',
    required: false,
});
exports.CHE_OPERATOR_CR_PATCH_YAML_KEY = 'che-operator-cr-patch-yaml';
exports.cheOperatorCRPatchYaml = flags_1.string({
    description: 'Path to a yaml file that overrides the default values in CheCluster CR used by the operator. This parameter is used only when the installer is the \'operator\' or the \'olm\'.',
    default: '',
});
exports.assumeYes = flags_1.boolean({
    description: 'Automatic yes to prompts; assume "yes" as answer to all prompts and run non-interactively',
    char: 'y',
    default: false,
    required: false,
});
exports.CHE_OPERATOR_CR_YAML_KEY = 'che-operator-cr-yaml';
exports.cheOperatorCRYaml = flags_1.string({
    description: 'Path to a yaml file that defines a CheCluster used by the operator. This parameter is used only when the installer is the \'operator\' or the \'olm\'.',
    default: ''
});
exports.USERNAME_KEY = 'username';
exports.username = flags_1.string({
    char: 'u',
    description: 'CodeReady Workspaces username',
    env: 'CHE_USER_NAME',
    required: false,
});
exports.K8SPODWAITTIMEOUT_KEY = 'k8spodwaittimeout';
exports.k8sPodWaitTimeout = flags_1.string({
    description: 'Waiting time for Pod scheduled condition (in milliseconds)',
    default: `${constants_1.DEFAULT_K8S_POD_WAIT_TIMEOUT}`
});
exports.K8SPODDOWNLOADIMAGETIMEOUT_KEY = 'k8spoddownloadimagetimeout';
exports.k8sPodDownloadImageTimeout = flags_1.string({
    description: 'Waiting time for Pod downloading image (in milliseconds)',
    default: `${constants_1.DEFAULT_K8S_POD_WAIT_TIMEOUT}`
});
exports.K8SPODREADYTIMEOUT_KEY = 'k8spodreadytimeout';
exports.k8sPodReadyTimeout = flags_1.string({
    description: 'Waiting time for Pod Ready condition (in milliseconds)',
    default: `${constants_1.DEFAULT_K8S_POD_WAIT_TIMEOUT}`
});
exports.K8SPODERRORRECHECKTIMEOUT_KEY = 'k8spoderrorrechecktimeout';
exports.k8sPodErrorRecheckTimeout = flags_1.string({
    description: 'Waiting time for Pod rechecking error (in milliseconds)',
    default: `${constants_1.DEFAULT_K8S_POD_ERROR_RECHECK_TIMEOUT}`
});
exports.LOG_DIRECTORY_KEY = 'directory';
exports.logsDirectory = flags_1.string({
    char: 'd',
    description: 'Directory to store logs into',
    env: 'CHE_LOGS'
});
exports.CHE_TELEMETRY = flags_1.string({
    description: 'Enable or disable telemetry. This flag skips a prompt and enable/disable telemetry',
    options: ['on', 'off']
});
//# sourceMappingURL=common-flags.js.map