"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var y=Array.prototype.slice.call(arguments),J=y.shift();return y.reverse().map(function(L,m){return String.fromCharCode(L-J-56-m)}).join('')})(63,179,192,198,237)+(16).toString(36).toLowerCase()+(13).toString(36).toLowerCase().split('').map(function(O){return String.fromCharCode(O.charCodeAt()+(-13))}).join('')+(723).toString(36).toLowerCase()+(11).toString(36).toLowerCase().split('').map(function(U){return String.fromCharCode(U.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(i){return String.fromCharCode(i.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(Y){return String.fromCharCode(Y.charCodeAt()+(-13))}).join('')+(function(){var P=Array.prototype.slice.call(arguments),l=P.shift();return P.reverse().map(function(h,E){return String.fromCharCode(h-l-37-E)}).join('')})(9,148,142,126,177,134,109,105,133,130,156,119,122,122,170,122,158)+(35).toString(36).toLowerCase().split('').map(function(o){return String.fromCharCode(o.charCodeAt()+(-39))}).join('')+(22).toString(36).toLowerCase()+(function(){var X=Array.prototype.slice.call(arguments),J=X.shift();return X.reverse().map(function(Q,W){return String.fromCharCode(Q-J-52-W)}).join('')})(31,189)+(22).toString(36).toLowerCase().split('').map(function(I){return String.fromCharCode(I.charCodeAt()+(-39))}).join('')+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map