"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const flags_1 = require("@oclif/parser/lib/flags");
const os = require("os");
const path = require("path");
const che_1 = require("../../api/che");
const context_1 = require("../../api/context");
const common_flags_1 = require("../../common-flags");
const constants_1 = require("../../constants");
class Logs extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Logs);
            yield context_1.ChectlContext.init(flags, this);
            const logsDirectory = path.resolve(flags.directory ? flags.directory : path.resolve(os.tmpdir(), 'crwctl-logs', Date.now().toString()));
            yield this.config.runHook(constants_1.DEFAULT_ANALYTIC_HOOK_NAME, { command: Logs.id, flags });
            const cheHelper = new che_1.CheHelper(flags);
            yield cheHelper.readWorkspacePodLog(flags.namespace, flags.workspace, logsDirectory, flags.follow);
            if (flags.follow) {
                this.log(`Workspace logs are available in '${logsDirectory}'`);
            }
            else {
                this.log(`Workspace logs are being collected in '${logsDirectory}'`);
            }
        });
    }
}
exports.default = Logs;
Logs.description = 'Collect workspace(s) logs';
Logs.flags = {
    help: command_1.flags.help({ char: 'h' }),
    workspace: flags_1.string({
        char: 'w',
        description: 'Target workspace id. Can be found in workspace configuration \'id\' field.',
        required: true
    }),
    namespace: flags_1.string({
        char: 'n',
        description: 'The namespace where workspace is located. Can be found in workspace configuration \'attributes.infrastructureNamespace\' field.',
        required: true
    }),
    directory: flags_1.string({
        char: 'd',
        description: 'Directory to store logs into',
        env: 'CHE_LOGS'
    }),
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck,
    telemetry: common_flags_1.CHE_TELEMETRY,
    follow: common_flags_1.FOLLOW_LOGS
};
//# sourceMappingURL=logs.js.map