"use strict";
/*********************************************************************
 * Copyright (c) 2019-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const che_1 = require("../../api/che");
const che_api_client_1 = require("../../api/che-api-client");
const che_login_manager_1 = require("../../api/che-login-manager");
const context_1 = require("../../api/context");
const common_flags_1 = require("../../common-flags");
const constants_1 = require("../../constants");
class Start extends command_1.default {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags, args } = this.parse(Start);
            yield context_1.ChectlContext.init(flags, this);
            yield this.config.runHook(constants_1.DEFAULT_ANALYTIC_HOOK_NAME, { command: Start.id, flags });
            const workspaceId = args.workspace;
            const cheHelper = new che_1.CheHelper(flags);
            const { cheApiEndpoint, accessToken } = yield che_login_manager_1.getLoginData(flags[common_flags_1.CHE_API_ENDPOINT_KEY], flags[common_flags_1.ACCESS_TOKEN_KEY], flags);
            const cheApiClient = che_api_client_1.CheApiClient.getInstance(cheApiEndpoint);
            yield cheApiClient.startWorkspace(workspaceId, flags.debug, accessToken);
            const workspace = yield cheApiClient.getWorkspaceById(workspaceId, accessToken);
            if (workspace.links && workspace.links.ide) {
                const workspaceIdeURL = yield cheHelper.buildDashboardURL(workspace.links.ide);
                cli_ux_1.cli.log('Workspace start request has been sent, workspace will be available shortly:');
                cli_ux_1.cli.url(workspaceIdeURL, workspaceIdeURL);
            }
            else {
                cli_ux_1.cli.log('Workspace start request has been sent, workspace will be available shortly.');
            }
            this.exit(0);
        });
    }
}
exports.default = Start;
Start.description = 'Starts a workspace';
Start.flags = {
    help: command_1.flags.help({ char: 'h' }),
    debug: command_1.flags.boolean({
        char: 'd',
        description: 'Debug workspace start. It is useful when workspace start fails and it is needed to print more logs on startup.',
        default: false
    }),
    [common_flags_1.CHE_API_ENDPOINT_KEY]: common_flags_1.cheApiEndpoint,
    [common_flags_1.ACCESS_TOKEN_KEY]: common_flags_1.accessToken,
    chenamespace: common_flags_1.cheNamespace,
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck,
    telemetry: common_flags_1.CHE_TELEMETRY
};
Start.args = [
    {
        name: 'workspace',
        description: 'The workspace id to start',
        required: true
    }
];
//# sourceMappingURL=start.js.map