"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const che_login_manager_1 = require("../../api/che-login-manager");
const context_1 = require("../../api/context");
const common_flags_1 = require("../../common-flags");
const constants_1 = require("../../constants");
class List extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(List);
            yield context_1.ChectlContext.init(flags, this);
            yield this.config.runHook(constants_1.DEFAULT_ANALYTIC_HOOK_NAME, { command: List.id, flags });
            const loginManager = yield che_login_manager_1.CheServerLoginManager.getInstance();
            const logins = loginManager.getAllLogins();
            const currentLogin = loginManager.getCurrentLoginInfo();
            this.printLogins(logins, currentLogin);
        });
    }
    printLogins(allLogins, currentLogin) {
        const currentLoginMarker = ' * ';
        const indent = '   ';
        let output;
        if (allLogins.size > 0) {
            output = 'Available logins:\n';
            allLogins.forEach((serverLogins, serverUrl) => {
                output += indent + serverUrl + '\n';
                for (const login of serverLogins) {
                    output += (currentLogin.cheApiEndpoint === serverUrl && currentLogin.username === login) ? currentLoginMarker : indent;
                    output += indent + login + '\n';
                }
            });
        }
        else {
            output = 'There are no login sessions';
        }
        cli_ux_1.cli.info(output);
    }
}
exports.default = List;
List.description = 'Show all existing login sessions';
List.flags = {
    help: command_1.flags.help({ char: 'h' }),
    telemetry: common_flags_1.CHE_TELEMETRY
};
//# sourceMappingURL=list.js.map