<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision: 1721976 -->
<!-- French translation : Lucien GENTIS -->
<!-- $LastChangedRevision: 2013010601 $ -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="password_encryptions.xml.meta">
  <parentdocument href="./">Documentations diverses</parentdocument>

  <title>Formats de mots de passe</title>

  <summary>
    <p>Notes &agrave; propos des formats de chiffrement des mots de passe
    g&eacute;n&eacute;r&eacute;s et compris par Apache.</p>
  </summary>

  <section id="basic"><title>Authentification de base</title>

    <p>Voici les cinq formats de mots de passe qu'Apache reconna&icirc;t
    pour l'authentification de base. Notez que tous les formats ne sont
    pas support&eacute;s par toutes les plates-formes :</p>

    <dl>
         
       <dt>bcrypt</dt>
       <dd>"$2y$" + the result of the crypt_blowfish algorithm. D&eacute;riv&eacute;
       de l'algorythme de chiffrement crypt_blowfish. Voir le fichier
       source APR <a
       href="http://svn.apache.org/viewvc/apr/apr/trunk/crypto/crypt_blowfish.c?view=markup">crypt_blowfish.c</a>
       pour plus de d&eacute;tails &agrave; propos de cet algorithme.</dd>

       <dt>MD5</dt>
       <dd>"$apr1$" + le r&eacute;sultat d'un algorithme sp&eacute;cifique &agrave; Apache
       utilisant un condens&eacute; MD5 r&eacute;it&eacute;r&eacute; (1000 fois) de combinaisons
       vari&eacute;es du mot de passe et d'une source d'entropie sur 32 bits.
       Voir le fichier source APR <a
       href="http://svn.apache.org/viewvc/apr/apr/trunk/crypto/apr_md5.c?view=markup">apr_md5.c</a>
       pour les d&eacute;tails de l'algorithme.</dd>
    

    <dt>SHA1</dt>
       <dd>"{SHA}" + un condens&eacute; SHA-1 du mot de passe cod&eacute; en
       Base64. Non s&ucirc;r.</dd>

    <dt>CRYPT</dt>
       <dd>Unix seulement. Utilise la fonction Unix traditionnelle
       <code>crypt(3)</code> avec une source d'entropie sur 32 bits
       (seuls 12 bits sont utilis&eacute;s), et seulement les 8 premiers
       caract&egrave;res du mot de passe. Non s&ucirc;r.</dd>

    <dt>PLAIN TEXT (autrement dit <em>non chiffr&eacute;</em>)</dt>
      <dd>Windows &amp; Netware seulement. Non s&ucirc;r.</dd>
    </dl>
    <section><title>G&eacute;n&eacute;rer des mots de passe avec htpasswd</title>

      <example><title>bcrypt</title>
      $ htpasswd -nbB monNom monMot-de-passe<br />
      monNom:$2y$05$c4WoMPo3SXsafkva.HHa6uXQZWr7oboPiC2bT/r7q1BB8I2s0BRqC
      </example>    

      <example><title>MD5</title>
      $ htpasswd -nbm monNom monMot-de-passe<br />
      monNom:$apr1$r31.....$HqJZimcKQFAMYayBlzkrA/
      </example>

      <example><title>SHA1</title>
      $ htpasswd -nbs monNom monMot-de-passe<br />
      monNom:{SHA}VBPuJHI7uixaa6LQGWx4s+5GKNE=
      </example>

      <example><title>CRYPT</title>
      $ htpasswd -nbd monNom monMot-de-passe<br />
      monNom:rqXexS6ZhobKA
      </example>

    </section>

    <section>
      <title>G&eacute;n&eacute;rer des mots de passe CRYPT and MD5 avec le programme
      OpenSSL en ligne de commande</title>

      <p>OpenSSL conna&icirc;t l'algorithme MD5 sp&eacute;cifique &agrave; Apache.</p>

      <example><title>MD5</title>
      $ openssl passwd -apr1 monMot-de-passe<br />
      $apr1$qHDFfhPC$nITSVHgYbDAK1Y0acGRnY0
      </example>

      <example><title>CRYPT</title>
      openssl passwd -crypt monMot-de-passe<br />
      qQ5vTYO3c8dsU
      </example>
    </section>

    <section>
      <title>Valider des mots de passe CRYPT and MD5 avec le programme
      OpenSSL en ligne de commande</title>
      <p>La source d'entropie pour un mot de passe CRYPT est constitu&eacute;e
      des deux premiers caract&egrave;res (convertis en valeur binaire). Pour
      valider <code>monMot-de-passe</code> par rapport &agrave;
      <code>rqXexS6ZhobKA</code></p>

      <example><title>CRYPT</title>
      $ openssl passwd -crypt -salt rq monMot-de-passe<br />
      Warning: truncating password to 8 characters<br />
      rqXexS6ZhobKA
      </example>

      <p>Notez que sp&eacute;cifier <code>monMot-d</code> au lieu de
      <code>monMot-de-passe</code> produira le m&ecirc;me r&eacute;sultat car seuls
      les 8 premiers caract&egrave;res des mots de passe CRYPT sont pris en
      compte.</p>

      <p>La source d'entropie pour un mot de passe MD5 se situe entre
      <code>$apr1$</code> et le caract&egrave;re <code>$</code> suivant (sous
      la forme d'une valeur binaire cod&eacute;e en Base64 - au maximum 8
      caract&egrave;res). Pour valider <code>monMot-de-passe</code> par rapport
      &agrave; <code>$apr1$r31.....$HqJZimcKQFAMYayBlzkrA/</code></p>

      <example><title>MD5</title>
      $ openssl passwd -apr1 -salt r31..... monMot-de-passe<br />
      $apr1$r31.....$HqJZimcKQFAMYayBlzkrA/
      </example>
    </section>

    <section><title>Champs mot de passe de base de donn&eacute;es pour
    mod_dbd</title>
      <p>La variante SHA1 constitue probablement le format le mieux
      appropri&eacute; pour l'authentification DBD. Comme les fonctions SHA1 et
      Base64 sont en g&eacute;n&eacute;ral disponibles, d'autres logiciels peuvent
      renseigner une base de donn&eacute;es avec des mots de passe chiffr&eacute;s
      utilisables par l'authentification basique d'Apache.</p>

      <p>Pour cr&eacute;er des mots de passe au format SHA1 pour
      l'authentification de base d'Apache dans divers langages :</p>

      <example><title>PHP</title>
      '{SHA}' . base64_encode(sha1($password, TRUE))
      </example>

      <example><title>Java</title>
      "{SHA}" + new sun.misc.BASE64Encoder().encode(java.security.MessageDigest.getInstance("SHA1").digest(password.getBytes()))
      </example>

      <example><title>ColdFusion</title>
      "{SHA}" &amp; ToBase64(BinaryDecode(Hash(password, "SHA1"), "Hex"))
      </example>

      <example><title>Ruby</title>
      require 'digest/sha1'<br />
      require 'base64'<br />
      '{SHA}' + Base64.encode64(Digest::SHA1.digest(password))
      </example>

      <example><title>C ou C++</title>
      Utilisez la fonction APR : apr_sha1_base64
      </example>

      <example><title>Python</title>
      import base64<br />
      import hashlib<br />
      "{SHA}" + format(base64.b64encode(hashlib.sha1(password).digest()))
      </example>

      <example>
        <title>PostgreSQL (avec les fonctions contrib/pgcrypto
               install&eacute;es)</title>
        '{SHA}'||encode(digest(password,'sha1'),'base64')
      </example>
    </section>

  </section>

  <section id="digest"><title>Authentification &agrave; base de condens&eacute;s</title>
    <p>Apache ne reconna&icirc;t qu'un format pour les mots de passe
    d'authentification &agrave; base de condens&eacute;s - le condens&eacute; MD5 de la
    cha&icirc;ne <code>utilisateur:domaine-de-protection:mot-de-passe</code>
    sous la forme d'une cha&icirc;ne de 32 caract&egrave;res au format hexad&eacute;cimal.
    <code>domaine-de-protection</code> est l'identifiant du domaine de
    protection de l'autorisation pass&eacute; en argument &agrave; la directive
    <directive module="mod_authn_core">AuthName</directive> dans
    httpd.conf.</p>

    <section><title>Champs de mot de passe de base de donn&eacute;es pour
    mod_dbd</title>

      <p>Comme la fonction MD5 est en g&eacute;n&eacute;ral disponible, d'autres
      logiciels peuvent renseigner une base de donn&eacute;es avec des mots de
      passe chiffr&eacute;s utilisables par l'authentification &agrave; base de
      condens&eacute;s d'Apache.</p>

      <p>Pour cr&eacute;er des mots de passe pour l'authentification &agrave; base de
      condens&eacute;s d'Apache dans divers langages :</p>

      <example><title>PHP</title>
      md5($user . ':' . $realm . ':' .$password)
      </example>

      <example><title>Java</title>
      byte b[] = java.security.MessageDigest.getInstance("MD5").digest( (user + ":" + realm + ":" + password ).getBytes());<br />
      java.math.BigInteger bi = new java.math.BigInteger(1, b);<br />
      String s = bi.toString(16);<br />
      while (s.length() &lt; 32)<br />
      <indent>
        s = "0" + s;
      </indent>
      // La cha&icirc;ne s contient le mot de passe chiffr&eacute;
      </example>

      <example><title>ColdFusion</title>
      LCase(Hash( (user &amp; ":" &amp; realm &amp; ":" &amp; password) , "MD5"))
      </example>

      <example><title>Ruby</title>
      require 'digest/md5'<br />
      Digest::MD5.hexdigest(user + ':' + realm + ':' + password)
      </example>

      <example>
        <title>PostgreSQL (avec les fonctions contrib/pgcrypto
	install&eacute;es)</title>
        encode(digest( user || ':' || realm || ':' || password , 'md5'), 'hex')
      </example>

    </section>
  </section>

</manualpage>
